/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import moa.classifiers.Classifier;
import moa.classifiers.Regressor;
import moa.classifiers.trees.FIMTDD;
import moa.options.ClassOption;
import weka.core.MOAUtils;

public class MOARegressorSetup
extends AbstractSource {
    private static final long serialVersionUID = 1357925227105730412L;
    protected ClassOption m_Regressor;
    protected Token m_OutputToken;

    public String globalInfo() {
        return "Outputs an instance of the specified MOA regressor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regressor", "regressor", (Object)this.getDefaultOption());
    }

    protected void initialize() {
        super.initialize();
        this.m_Regressor = this.getDefaultOption();
    }

    protected Classifier getDefaultRegressor() {
        return new FIMTDD();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption("regressor", 'r', "The MOA regressor to use from within ADAMS.", Regressor.class, this.getDefaultRegressor().getClass().getName().replace("moa.classifiers.", ""), this.getDefaultRegressor().getClass().getName());
    }

    public void setRegressor(ClassOption value) {
        this.m_Regressor.setValueViaCLIString(value.getValueAsCLIString());
        this.reset();
    }

    public ClassOption getRegressor() {
        return this.m_Regressor;
    }

    public String classifierTipText() {
        return "The MOA regressor to output.";
    }

    protected Regressor getCurrentRegressor() {
        return (Regressor)MOAUtils.fromOption((ClassOption)this.m_Regressor);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"regressor", this.getCurrentRegressor().getClass());
    }

    public Class[] generates() {
        return new Class[]{Regressor.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Regressor cls = (Regressor)MOAUtils.fromOption((ClassOption)this.m_Regressor);
            this.m_OutputToken = new Token((Object)cls);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to create copy of regressor:", e);
        }
        return result;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

