/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.help;

import adams.gui.core.ConsolePanel;
import adams.gui.help.AbstractHelpGenerator;
import java.util.logging.Level;
import moa.MOAObject;
import moa.options.Option;
import moa.options.OptionHandler;
import nz.ac.waikato.cms.locator.ClassLocator;

public class MOAObjectHelpGenerator
extends AbstractHelpGenerator {
    public boolean handles(Class cls) {
        return ClassLocator.hasInterface(MOAObject.class, (Class)cls);
    }

    public boolean isHtml(Class cls) {
        return false;
    }

    public String generate(Class cls) {
        MOAObject obj;
        try {
            obj = (MOAObject)cls.newInstance();
        }
        catch (Exception ex) {
            ConsolePanel.getSingleton().append((Object)Level.SEVERE, ((Object)((Object)this)).getClass().getName() + ": Failed to instantiate class: " + cls.getName(), (Throwable)ex);
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("DESCRIPTION\n\n");
        result.append(obj.getClass().getName());
        result.append("\n\n");
        if (obj instanceof OptionHandler) {
            result.append("OPTIONS\n\n");
            OptionHandler handler = (OptionHandler)obj;
            for (Option opt : handler.getOptions().getOptionArray()) {
                result.append(opt.getName() + "/-" + opt.getCLIChar() + "\n");
                result.append(opt.getPurpose() + "\n");
                result.append("\n");
            }
        }
        return result.toString();
    }
}

