/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.data.conversion.Conversion;
import adams.data.conversion.WEKAInstancesToMOAInstances;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.source.MOAClustererSetup;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.Convert;
import adams.flow.transformer.MOATrainClusterer;
import adams.flow.transformer.WekaFileReader;
import adams.flow.transformer.WekaFilter;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import moa.clusterers.Clusterer;
import moa.options.ClassOption;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class MOAClustererSetupTest
extends AbstractFlowTest {
    public MOAClustererSetupTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public Actor getActor() {
        CallableActors ga = new CallableActors();
        ClassOption option = new ClassOption("clusterer", 'c', "The MOA clusterer to use from within ADAMS.", Clusterer.class, "CobWeb", "moa.clusterers.CobWeb");
        MOAClustererSetup cls = new MOAClustererSetup();
        cls.setName("cls");
        cls.setClusterer(option);
        ga.add((Actor)cls);
        FileSupplier sfs = new FileSupplier();
        sfs.setFiles(new PlaceholderFile[]{new TmpFile("iris.arff")});
        WekaFileReader fr = new WekaFileReader();
        fr.setOutputType(WekaFileReader.OutputType.DATASET);
        Remove remove = new Remove();
        remove.setAttributeIndices("last");
        WekaFilter wf = new WekaFilter();
        wf.setFilter((Filter)remove);
        Convert convert = new Convert();
        convert.setConversion((Conversion)new WEKAInstancesToMOAInstances());
        MOATrainClusterer cts = new MOATrainClusterer();
        cts.setClusterer(new CallableActorReference("cls"));
        cts.setOutputInterval(150);
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{ga, sfs, fr, wf, convert, cts, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(MOAClustererSetupTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOAClustererSetupTest.runTest((Test)MOAClustererSetupTest.suite());
    }
}

