/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.source.MOAStream;
import adams.flow.transformer.MOAInstanceDumper;
import adams.flow.transformer.MOARegressing;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import moa.options.ClassOption;
import moa.streams.ExampleStream;

public class MOARegressingTest
extends AbstractFlowTest {
    public MOARegressingTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.arff");
        this.m_TestHelper.copyResourceToTmp("fimtdd.model");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.arff");
        this.m_TestHelper.deleteFileFromTmp("fimtdd.model");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.arff");
        super.tearDown();
    }

    public Actor getActor() {
        ClassOption arffOption = new ClassOption("stream", 's', "The MOA stream generator to use from within ADAMS.", ExampleStream.class, "ArffFileStream -f (" + new TmpFile("bolts.arff").getAbsolutePath() + ")", "moa.streams.ArffFileStream");
        MOAStream stream = new MOAStream();
        stream.setNumExamples(-1);
        stream.setStreamGenerator(arffOption);
        MOARegressing cls = new MOARegressing();
        cls.setOutputInstance(true);
        cls.setModelFile((PlaceholderFile)new TmpFile("fimtdd.model"));
        MOAInstanceDumper id = new MOAInstanceDumper();
        id.setOutputPrefix((PlaceholderFile)new TmpFile("dumpfile"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{stream, cls, id});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.arff"));
    }

    public static Test suite() {
        return new TestSuite(MOARegressingTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOARegressingTest.runTest((Test)MOARegressingTest.suite());
    }
}

