/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingLevel;
import adams.core.option.OptionHandler;
import adams.event.VariableChangeEvent;
import adams.flow.control.StorageName;
import adams.flow.core.AbstractModelLoader;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.core.DynamicModelLoaderSupporter;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.Hashtable;

public abstract class AbstractProcessMOAInstanceWithModel<T>
extends AbstractTransformer
implements DynamicModelLoaderSupporter {
    private static final long serialVersionUID = 3850507205836680544L;
    public static final String BACKUP_MODEL = "model";
    protected T m_Model;
    protected boolean m_OnTheFly;
    protected boolean m_UseModelResetVariable;
    protected VariableName m_ModelResetVariable;
    protected boolean m_ResetModel;
    protected AbstractModelLoader m_ModelLoader;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("model-loading-type", "modelLoadingType", (Object)AbstractModelLoader.ModelLoadingType.AUTO);
        this.m_OptionManager.add(BACKUP_MODEL, "modelFile", (Object)new PlaceholderFile("."));
        this.m_OptionManager.add("model-actor", "modelActor", (Object)new CallableActorReference());
        this.m_OptionManager.add("model-storage", "modelStorage", (Object)new StorageName());
        this.m_OptionManager.add("on-the-fly", "onTheFly", (Object)false);
        this.m_OptionManager.add("use-model-reset-variable", "useModelResetVariable", (Object)false);
        this.m_OptionManager.add("model-reset-variable", "modelResetVariable", (Object)new VariableName());
    }

    protected void initialize() {
        super.initialize();
        this.m_ModelLoader = this.newModelLoader();
        this.m_ModelLoader.setFlowContext((Actor)this);
    }

    protected void reset() {
        super.reset();
        this.m_Model = null;
        this.m_ModelLoader.reset();
    }

    public synchronized void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_ModelLoader.setLoggingLevel(value);
    }

    protected abstract AbstractModelLoader newModelLoader();

    public void setModelLoadingType(AbstractModelLoader.ModelLoadingType value) {
        this.m_ModelLoader.setModelLoadingType(value);
        this.reset();
    }

    public AbstractModelLoader.ModelLoadingType getModelLoadingType() {
        return this.m_ModelLoader.getModelLoadingType();
    }

    public String modelLoadingTypeTipText() {
        return this.m_ModelLoader.modelLoadingTypeTipText();
    }

    public void setModelFile(PlaceholderFile value) {
        this.m_ModelLoader.setModelFile(value);
        this.reset();
    }

    public PlaceholderFile getModelFile() {
        return this.m_ModelLoader.getModelFile();
    }

    public String modelFileTipText() {
        return this.m_ModelLoader.modelFileTipText();
    }

    public void setModelActor(CallableActorReference value) {
        this.m_ModelLoader.setModelActor(value);
        this.reset();
    }

    public CallableActorReference getModelActor() {
        return this.m_ModelLoader.getModelActor();
    }

    public String modelActorTipText() {
        return this.m_ModelLoader.modelActorTipText();
    }

    public void setModelStorage(StorageName value) {
        this.m_ModelLoader.setModelStorage(value);
        this.reset();
    }

    public StorageName getModelStorage() {
        return this.m_ModelLoader.getModelStorage();
    }

    public String modelStorageTipText() {
        return this.m_ModelLoader.modelStorageTipText();
    }

    public void setOnTheFly(boolean value) {
        this.m_OnTheFly = value;
        this.reset();
    }

    public boolean getOnTheFly() {
        return this.m_OnTheFly;
    }

    public String onTheFlyTipText() {
        return "If set to true, the model file is not required to be present at set up time (eg if built on the fly), only at execution time.";
    }

    public void setUseModelResetVariable(boolean value) {
        this.m_UseModelResetVariable = value;
        this.reset();
    }

    public boolean getUseModelResetVariable() {
        return this.m_UseModelResetVariable;
    }

    public String useModelResetVariableTipText() {
        return "If enabled, chnages to the specified variable are monitored in order to reset the model, eg when a storage model changed.";
    }

    public void setModelResetVariable(VariableName value) {
        this.m_ModelResetVariable = value;
        this.reset();
    }

    public VariableName getModelResetVariable() {
        return this.m_ModelResetVariable;
    }

    public String modelResetVariableTipText() {
        return "The variable to monitor for changes in order to reset the model, eg when a storage model changed.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"modelLoadingType", (Object)this.getModelLoadingType(), (String)"type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"modelFile", (Object)this.getModelFile(), (String)", model: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"modelSource", (Object)this.getModelActor(), (String)", source: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"modelStorage", (Object)this.getModelStorage(), (String)", storage: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"modelResetVariable", (Object)(this.m_UseModelResetVariable ? "reset: " + this.m_ModelResetVariable : ""));
        if (value != null) {
            result = result + ", " + value;
        }
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instance.class};
    }

    public abstract Class[] generates();

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_MODEL);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Model != null) {
            result.put(BACKUP_MODEL, this.m_Model);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_MODEL)) {
            this.m_Model = state.get(BACKUP_MODEL);
            state.remove(BACKUP_MODEL);
        }
        super.restoreState(state);
    }

    public void variableChanged(VariableChangeEvent e) {
        super.variableChanged(e);
        if (e.getName().equals(this.m_ModelResetVariable.getValue())) {
            this.m_ResetModel = true;
        }
    }

    protected String setUpModel() {
        String result = null;
        if (this.m_ResetModel) {
            this.m_ModelLoader.reset();
        }
        MessageCollection errors = new MessageCollection();
        this.m_Model = this.m_ModelLoader.getModel(errors);
        if (this.m_Model == null) {
            result = errors.toString();
        }
        this.m_ResetModel = false;
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null && !this.m_OnTheFly) {
            result = this.setUpModel();
        }
        return result;
    }

    protected abstract Token processInstance(Instance var1) throws Exception;

    protected String doExecute() {
        String result = null;
        if ((this.m_OnTheFly && this.m_Model == null || this.m_ResetModel) && (result = this.setUpModel()) != null) {
            return result;
        }
        Instance inst = null;
        try {
            inst = (Instance)this.m_InputToken.getPayload(Instance.class);
            this.m_OutputToken = this.processInstance(inst);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to process instance: " + inst, e);
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_Model = null;
    }
}

