/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.statistics.StatUtils;
import adams.flow.container.MOAClusteringContainer;
import adams.flow.core.AbstractModelLoader;
import adams.flow.core.MOAClustererModelLoader;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractProcessMOAInstanceWithModel;
import com.yahoo.labs.samoa.instances.Instance;
import moa.clusterers.Clusterer;

public class MOAClustering
extends AbstractProcessMOAInstanceWithModel<Clusterer> {
    private static final long serialVersionUID = 8362932772732931480L;
    protected boolean m_UpdateModel;

    public String globalInfo() {
        return "Uses a serialized MOA model to cluster data being passed through.\n" + this.m_ModelLoader.automaticOrderInfo() + "\nOptionally, the model can be updated with data being passed through.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("update-model", "updateModel", (Object)false);
    }

    @Override
    protected AbstractModelLoader newModelLoader() {
        return new MOAClustererModelLoader();
    }

    public void setUpdateModel(boolean value) {
        this.m_UpdateModel = value;
        this.reset();
    }

    public boolean getUpdateModel() {
        return this.m_UpdateModel;
    }

    public String updateModelTipText() {
        return "Whether to update the model with the Instance after making the prediction.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{MOAClusteringContainer.class};
    }

    @Override
    protected Token processInstance(Instance inst) throws Exception {
        double[] vote = ((Clusterer)this.m_Model).getVotesForInstance(inst);
        MOAClusteringContainer cont = new MOAClusteringContainer(inst, StatUtils.minIndex((double[])vote), vote);
        if (this.m_UpdateModel) {
            ((Clusterer)this.m_Model).trainOnInstance(inst);
        }
        Token result = new Token((Object)cont.getClone());
        return result;
    }
}

