/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.InstanceImpl;
import java.util.ArrayList;
import java.util.Enumeration;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class MOAHelper {
    public static double[] fixVotes(double[] votes, com.yahoo.labs.samoa.instances.Instance inst) {
        if (inst.classIndex() == -1) {
            return votes;
        }
        if (votes.length == inst.numClasses()) {
            return votes;
        }
        double[] result = new double[inst.numClasses()];
        System.arraycopy(votes, 0, result, 0, votes.length);
        return result;
    }

    public static com.yahoo.labs.samoa.instances.Instances toMOAInstances(Instances instances) {
        if (instances == null) {
            return null;
        }
        Attribute[] moaAttributes = new Attribute[instances.numAttributes()];
        for (int i = 0; i < instances.numAttributes(); ++i) {
            moaAttributes[i] = MOAHelper.toMOAAttribute(instances.attribute(i));
        }
        com.yahoo.labs.samoa.instances.Instances moaInstances = new com.yahoo.labs.samoa.instances.Instances(instances.relationName(), moaAttributes, instances.numInstances());
        moaInstances.setClassIndex(instances.classIndex());
        for (int i = 0; i < instances.numInstances(); ++i) {
            com.yahoo.labs.samoa.instances.Instance moaInstance = MOAHelper.toMOAInstance(instances.get(i));
            moaInstance.setDataset(moaInstances);
            moaInstances.add(moaInstance);
        }
        return moaInstances;
    }

    public static com.yahoo.labs.samoa.instances.Instance toMOAInstance(Instance inst) {
        if (inst == null) {
            return null;
        }
        return new InstanceImpl(inst.weight(), inst.toDoubleArray());
    }

    public static Attribute toMOAAttribute(weka.core.Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.isNumeric()) {
            return new Attribute(attribute.name());
        }
        if (attribute.isNominal()) {
            ArrayList<String> nominalValues = new ArrayList<String>(attribute.numValues());
            Enumeration nominalValueEnumeration = attribute.enumerateValues();
            while (nominalValueEnumeration.hasMoreElements()) {
                nominalValues.add((String)nominalValueEnumeration.nextElement());
            }
            return new Attribute(attribute.name(), nominalValues);
        }
        if (attribute.isDate()) {
            return new Attribute(attribute.name(), attribute.getDateFormat());
        }
        throw new IllegalArgumentException("toMOAAttribute can only handle numeric,nominal and date attributes.");
    }

    public static Instances toWEKAInstances(com.yahoo.labs.samoa.instances.Instances instances) {
        if (instances == null) {
            return null;
        }
        ArrayList<weka.core.Attribute> wekaAttributes = new ArrayList<weka.core.Attribute>(instances.numAttributes());
        for (int i = 0; i < instances.numAttributes(); ++i) {
            wekaAttributes.add(MOAHelper.toWEKAAttribute(instances.attribute(i)));
        }
        Instances wekaInstances = new Instances(instances.getRelationName(), wekaAttributes, instances.numInstances());
        wekaInstances.setClassIndex(instances.classIndex());
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance wekaInstance = MOAHelper.toWEKAInstance(instances.get(i));
            wekaInstance.setDataset(wekaInstances);
            wekaInstances.add(wekaInstance);
        }
        return wekaInstances;
    }

    public static Instance toWEKAInstance(com.yahoo.labs.samoa.instances.Instance inst) {
        if (inst == null) {
            return null;
        }
        return new DenseInstance(inst.weight(), inst.toDoubleArray());
    }

    public static weka.core.Attribute toWEKAAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.isNumeric()) {
            return new weka.core.Attribute(attribute.name());
        }
        if (attribute.isNominal()) {
            return new weka.core.Attribute(attribute.name(), attribute.getAttributeValues());
        }
        throw new IllegalArgumentException("toWEKAAttribute can only handle numeric andnominal attributes");
    }

    public static boolean equalHeaders(com.yahoo.labs.samoa.instances.Instances inst1, com.yahoo.labs.samoa.instances.Instances inst2) {
        if (inst1 == null || inst2 == null) {
            return false;
        }
        if (inst1.classIndex() != inst2.classIndex()) {
            return false;
        }
        if (inst1.numAttributes() != inst2.numAttributes()) {
            return false;
        }
        for (int i = 0; i < inst1.numAttributes(); ++i) {
            if (MOAHelper.equalAttributes(inst1.attribute(i), inst2.attribute(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalAttributes(Attribute attr1, Attribute attr2) {
        if (attr1 == null || attr2 == null) {
            return false;
        }
        return attr1.toString().equals(attr2.toString());
    }
}

