/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.ArrayList;
import java.util.Iterator;

public class MOAClusteringContainer
extends AbstractContainer {
    private static final long serialVersionUID = 5572674134848211211L;
    public static final String VALUE_INSTANCE = "Instance";
    public static final String VALUE_CLUSTER = "Cluster";
    public static final String VALUE_DISTRIBUTION = "Distribution";
    public static final String VALUE_LOGDENSITY = "LogDensity";
    public static final String VALUE_LOGDENSITYPERCLUSTER = "LogDensityPerCluster";
    public static final String VALUE_LOGJOINTDENSITIES = "LogJointDensities";

    public MOAClusteringContainer() {
        this(null, -1, new double[0]);
    }

    public MOAClusteringContainer(Instance inst, int cluster, double[] dist) {
        this(inst, cluster, dist, 0.0, new double[0], new double[0]);
    }

    public MOAClusteringContainer(Instance inst, int cluster, double[] dist, double logDensity, double[] logDensityPerCluster, double[] logJointDensities) {
        if (inst != null) {
            this.store(VALUE_INSTANCE, inst.copy());
        }
        this.store(VALUE_CLUSTER, cluster);
        this.store(VALUE_DISTRIBUTION, dist.clone());
        if (logDensityPerCluster.length > 0) {
            this.store(VALUE_LOGDENSITY, logDensity);
            this.store(VALUE_LOGDENSITYPERCLUSTER, logDensityPerCluster.clone());
            this.store(VALUE_LOGJOINTDENSITIES, logJointDensities.clone());
        }
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_INSTANCE, "data row", Instance.class);
        this.addHelp(VALUE_CLUSTER, "cluster index (0-based)", Integer.class);
        this.addHelp(VALUE_DISTRIBUTION, "cluster distribution; array of " + Double.TYPE.getName());
        this.addHelp(VALUE_LOGDENSITY, "log density", Double.class);
        this.addHelp(VALUE_LOGDENSITYPERCLUSTER, "log density per cluster; array of " + Double.TYPE.getName());
        this.addHelp(VALUE_LOGJOINTDENSITIES, "log joint densities; array of " + Double.TYPE.getName());
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_INSTANCE);
        result.add(VALUE_CLUSTER);
        result.add(VALUE_DISTRIBUTION);
        result.add(VALUE_LOGDENSITY);
        result.add(VALUE_LOGDENSITYPERCLUSTER);
        result.add(VALUE_LOGJOINTDENSITIES);
        return result.iterator();
    }

    public boolean isValid() {
        return (this.hasValue(VALUE_INSTANCE) && this.hasValue(VALUE_CLUSTER) && this.hasValue(VALUE_DISTRIBUTION) && !this.hasValue(VALUE_LOGDENSITY) && !this.hasValue(VALUE_LOGDENSITYPERCLUSTER) && !this.hasValue(VALUE_LOGJOINTDENSITIES)) | (this.hasValue(VALUE_INSTANCE) && this.hasValue(VALUE_CLUSTER) && this.hasValue(VALUE_DISTRIBUTION) && this.hasValue(VALUE_LOGDENSITY) && this.hasValue(VALUE_LOGDENSITYPERCLUSTER) && this.hasValue(VALUE_LOGJOINTDENSITIES));
    }
}

