/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.data.report.Report;
import adams.flow.container.AbstractContainer;
import adams.flow.container.ContainerWithReport;
import com.yahoo.labs.samoa.instances.Instance;
import java.util.ArrayList;
import java.util.Iterator;
import weka.core.Utils;

public class MOAPredictionContainer
extends AbstractContainer
implements ContainerWithReport {
    private static final long serialVersionUID = 872330681430825295L;
    public static final String VALUE_INSTANCE = "Instance";
    public static final String VALUE_CLASSIFICATION = "Classification";
    public static final String VALUE_CLASSIFICATION_LABEL = "Classification label";
    public static final String VALUE_DISTRIBUTION = "Distribution";
    public static final String VALUE_RANGECHECK = "Range check";
    public static final String VALUE_ABSTENTION_CLASSIFICATION = "Abstention classification";
    public static final String VALUE_ABSTENTION_CLASSIFICATION_LABEL = "Abstention classification label";
    public static final String VALUE_ABSTENTION_DISTRIBUTION = "Abstention distribution";

    public MOAPredictionContainer() {
        this(null, Utils.missingValue(), new double[0]);
    }

    public MOAPredictionContainer(Instance inst, double cls, double[] dist) {
        this(inst, cls, dist, null);
    }

    public MOAPredictionContainer(Instance inst, double cls, double[] dist, String rangeCheck) {
        if (inst != null) {
            this.store(VALUE_INSTANCE, inst.copy());
        }
        this.store(VALUE_CLASSIFICATION, cls);
        this.store(VALUE_DISTRIBUTION, dist.clone());
        if (inst != null && inst.classAttribute().isNominal()) {
            this.store(VALUE_CLASSIFICATION_LABEL, inst.classAttribute().value((int)cls));
        }
        if (rangeCheck != null) {
            this.store(VALUE_RANGECHECK, rangeCheck);
        }
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_INSTANCE, "data row used for prediction", Instance.class);
        this.addHelp(VALUE_CLASSIFICATION, "predicted value", Double.class);
        this.addHelp(VALUE_CLASSIFICATION_LABEL, "predicted label", String.class);
        this.addHelp(VALUE_DISTRIBUTION, "class distribution; array of " + Double.TYPE.getName());
        this.addHelp(VALUE_RANGECHECK, "range check", String.class);
        this.addHelp(VALUE_ABSTENTION_CLASSIFICATION, "predicted value that made classifier abstain", Double.class);
        this.addHelp(VALUE_ABSTENTION_CLASSIFICATION_LABEL, "predicted label that made classifier abstain", String.class);
        this.addHelp(VALUE_ABSTENTION_DISTRIBUTION, "class distribution that made classifier abstain; array of " + Double.TYPE.getName());
        this.addHelp("Report", "report for storing meta-data", Report.class);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_INSTANCE);
        result.add(VALUE_CLASSIFICATION);
        result.add(VALUE_CLASSIFICATION_LABEL);
        result.add(VALUE_DISTRIBUTION);
        result.add(VALUE_RANGECHECK);
        result.add(VALUE_ABSTENTION_CLASSIFICATION);
        result.add(VALUE_ABSTENTION_CLASSIFICATION_LABEL);
        result.add(VALUE_ABSTENTION_DISTRIBUTION);
        result.add("Report");
        return result.iterator();
    }

    public boolean isValid() {
        return (this.hasValue(VALUE_INSTANCE) && this.hasValue(VALUE_CLASSIFICATION) && this.hasValue(VALUE_DISTRIBUTION) && !this.hasValue(VALUE_CLASSIFICATION_LABEL)) | (this.hasValue(VALUE_INSTANCE) && this.hasValue(VALUE_CLASSIFICATION) && this.hasValue(VALUE_DISTRIBUTION) && this.hasValue(VALUE_CLASSIFICATION_LABEL));
    }
}

