/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.License;
import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.annotation.MixedCopyright;
import adams.core.base.BaseMeasureCollection;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.source.MOAClustererSetup;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.TextPanel;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstanceImpl;
import com.yahoo.labs.samoa.instances.Instances;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import moa.cluster.Clustering;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.ClusterGenerator;
import moa.clusterers.KMeans;
import moa.evaluation.MeasureCollection;
import moa.gui.visualization.DataPoint;
import moa.gui.visualization.GraphCanvas;
import moa.gui.visualization.StreamPanel;

@MixedCopyright(author="Jansen moa@cs.rwth-aachen.de", license=License.APACHE2, note="Code extracted from: moa.gui.visualization.RunVisualizer")
public class MOAClusterVisualization
extends AbstractGraphicalDisplay {
    private static final long serialVersionUID = -7015408219912566981L;
    protected CallableActorReference m_Clusterer;
    protected BaseMeasureCollection[] m_Measures;
    protected MeasureCollection[] m_ActualMeasures;
    protected int m_DecayHorizon;
    protected double m_DecayThreshold;
    protected boolean m_DrawPoints;
    protected boolean m_DrawGroundTruth;
    protected boolean m_DrawMicroClustering;
    protected boolean m_DrawClustering;
    protected int m_ProcessFrequency;
    protected int m_RedrawInterval;
    protected StreamPanel m_StreamPanel;
    protected AbstractClusterer m_ActualClusterer;
    protected double m_DecayRate;
    protected Clustering m_gtClustering;
    protected Clustering m_Macro;
    protected Clustering m_Micro;
    protected GraphCanvas m_Graphcanvas;
    protected TextPanel m_LogPanel;
    protected LinkedList<DataPoint> m_PointBuffer;
    protected ArrayList<DataPoint> m_PointArray;
    protected int m_Timestamp;
    protected int m_ProcessCounter;
    protected int m_SpeedCounter;
    protected BaseComboBox<String> m_ComboBoxDimX;
    protected BaseComboBox<String> m_ComboBoxDimY;

    public String globalInfo() {
        return "Visualizes MOA clusters.";
    }

    protected void reset() {
        super.reset();
        this.m_PointBuffer = new LinkedList();
        this.m_PointArray = null;
        this.m_Timestamp = 0;
        this.m_ProcessCounter = 0;
        this.m_SpeedCounter = 0;
        this.m_gtClustering = null;
        this.m_Macro = null;
        this.m_Micro = null;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("clusterer", "clusterer", (Object)new CallableActorReference(MOAClustererSetup.class.getSimpleName()));
        this.m_OptionManager.add("measure", "measures", (Object)new BaseMeasureCollection[0]);
        this.m_OptionManager.add("decay-horizon", "decayHorizon", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("process-frequency", "processFrequency", (Object)1000, (Number)1, null);
        this.m_OptionManager.add("redraw-interval", "redrawInterval", (Object)100, (Number)1, null);
        this.m_OptionManager.add("draw-points", "drawPoints", (Object)true);
        this.m_OptionManager.add("draw-ground-truth", "drawGroundTruth", (Object)true);
        this.m_OptionManager.add("draw-micro-clustering", "drawMicroClustering", (Object)true);
        this.m_OptionManager.add("draw-clustering", "drawClustering", (Object)true);
    }

    public void setClusterer(CallableActorReference value) {
        this.m_Clusterer = value;
        this.reset();
    }

    public CallableActorReference getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The name of the callable MOA clusterer to visualize.";
    }

    public void setDecayHorizon(int value) {
        this.m_DecayHorizon = value;
        this.reset();
    }

    public int getDecayHorizon() {
        return this.m_DecayHorizon;
    }

    public String decayHorizonTipText() {
        return "The size of the decay horizon in data points (= sliding window).";
    }

    public void setProcessFrequency(int value) {
        this.m_ProcessFrequency = value;
        this.reset();
    }

    public int getProcessFrequency() {
        return this.m_ProcessFrequency;
    }

    public String processFrequencyTipText() {
        return "The amount of instances to process in one step.";
    }

    public void setRedrawInterval(int value) {
        this.m_RedrawInterval = value;
        this.reset();
    }

    public int getRedrawInterval() {
        return this.m_RedrawInterval;
    }

    public String redrawIntervalTipText() {
        return "After how many instances do we repaint.";
    }

    public void setDrawPoints(boolean value) {
        this.m_DrawPoints = value;
        this.reset();
    }

    public boolean getDrawPoints() {
        return this.m_DrawPoints;
    }

    public String drawPointsTipText() {
        return "Whether to draw the points.";
    }

    public void setDrawGroundTruth(boolean value) {
        this.m_DrawGroundTruth = value;
        this.reset();
    }

    public boolean getDrawGroundTruth() {
        return this.m_DrawGroundTruth;
    }

    public String drawGroundTruthTipText() {
        return "Whether to draw the ground truth.";
    }

    public void setDrawMicroClustering(boolean value) {
        this.m_DrawMicroClustering = value;
        this.reset();
    }

    public boolean getDrawMicroClustering() {
        return this.m_DrawMicroClustering;
    }

    public String drawMicroClusteringTipText() {
        return "Whether to draw the micro clustering.";
    }

    public void setDrawClustering(boolean value) {
        this.m_DrawClustering = value;
        this.reset();
    }

    public boolean getDrawClustering() {
        return this.m_DrawClustering;
    }

    public String drawClusteringTipText() {
        return "Whether to draw the clustering.";
    }

    public void setMeasures(BaseMeasureCollection[] value) {
        this.m_Measures = value;
        this.m_ActualMeasures = new MeasureCollection[this.m_Measures.length];
        for (int i = 0; i < this.m_Measures.length; ++i) {
            this.m_ActualMeasures[i] = this.m_Measures[i].collectionValue();
        }
        this.reset();
    }

    public BaseMeasureCollection[] getMeasures() {
        return this.m_Measures;
    }

    public String measuresTipText() {
        return "The measures to collect.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"clusterer", (Object)this.m_Clusterer);
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, Instances.class};
    }

    protected AbstractClusterer getClustererInstance() {
        MessageCollection errors = new MessageCollection();
        AbstractClusterer result = (AbstractClusterer)CallableActorHelper.getSetup(AbstractClusterer.class, (CallableActorReference)this.m_Clusterer, (Actor)this, (MessageCollection)errors);
        if (result == null && !errors.isEmpty()) {
            this.getLogger().severe(errors.toString());
        }
        return result;
    }

    protected void drawClusterings(List<DataPoint> points) {
        if (this.m_Macro != null && this.m_Macro.size() > 0) {
            this.m_StreamPanel.drawMacroClustering(this.m_Macro, points, Color.RED);
        }
        if (this.m_Micro != null && this.m_Micro.size() > 0) {
            this.m_StreamPanel.drawMicroClustering(this.m_Micro, points, Color.GREEN);
        }
        if (this.m_gtClustering != null && this.m_gtClustering.size() > 0) {
            this.m_StreamPanel.drawGTClustering(this.m_gtClustering, points, Color.BLACK);
        }
    }

    protected void evaluateClustering(Clustering found_clustering, Clustering trueClustering, ArrayList<DataPoint> points, boolean algorithm) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.m_ActualMeasures.length; ++i) {
            if (!algorithm) continue;
            if (found_clustering != null && found_clustering.size() > 0) {
                try {
                    double msec = this.m_ActualMeasures[i].evaluateClusteringPerformance(found_clustering, trueClustering, points);
                    sb.append(this.m_ActualMeasures[i].getClass().getSimpleName() + " took " + msec + "ms (Mean:" + this.m_ActualMeasures[i].getMeanRunningTime() + ")");
                    sb.append("\n");
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to evaluate clustering performance:", (Throwable)e);
                }
                continue;
            }
            for (int j = 0; j < this.m_ActualMeasures[i].getNumMeasures(); ++j) {
                this.m_ActualMeasures[i].addEmptyValue(j);
            }
        }
        this.m_LogPanel.setContent(sb.toString());
        this.m_Graphcanvas.updateCanvas();
    }

    protected void processClusterings(ArrayList<DataPoint> points) {
        this.m_gtClustering = new Clustering(points);
        if (this.m_ActualClusterer instanceof ClusterGenerator) {
            ((ClusterGenerator)this.m_ActualClusterer).setSourceClustering(this.m_gtClustering);
        }
        Clustering evalClustering = this.m_Macro = this.m_ActualClusterer.getClusteringResult();
        if (this.m_ActualClusterer.implementsMicroClusterer()) {
            this.m_Micro = this.m_ActualClusterer.getMicroClusteringResult();
            if (this.m_Macro == null && this.m_Micro != null) {
                this.m_Macro = KMeans.gaussianMeans((Clustering)this.m_gtClustering, (Clustering)this.m_Micro);
            }
            evalClustering = this.m_ActualClusterer.evaluateMicroClusteringOption.isSet() ? this.m_Micro : this.m_Macro;
        }
        this.evaluateClustering(evalClustering, this.m_gtClustering, points, true);
        this.drawClusterings(points);
    }

    protected void display(Token token) {
        int i;
        ArrayList<Instance> list;
        boolean first = false;
        if (this.m_ActualClusterer == null) {
            this.m_ActualClusterer = this.getClustererInstance();
            if (this.m_ActualClusterer == null) {
                throw new IllegalStateException("Failed to get instance of clusterer '" + this.m_Clusterer + "'!");
            }
            this.m_ActualClusterer.prepareForUse();
            first = true;
        }
        if (this.m_ActualMeasures.length == 0) {
            throw new IllegalStateException("No measures configured!");
        }
        this.m_DecayRate = Math.log(1.0 / this.m_DecayThreshold) / Math.log(2.0) / (double)this.m_DecayHorizon;
        if (token.getPayload() instanceof Instance) {
            list = new ArrayList<Instance>();
            list.add((Instance)token.getPayload());
        } else {
            list = new ArrayList();
            Instances instances = (Instances)token.getPayload();
            for (i = 0; i < instances.numInstances(); ++i) {
                list.add(instances.get(i));
            }
        }
        if (first) {
            ArrayList<String> atts = new ArrayList<String>();
            for (i = 0; i < ((Instance)list.get(0)).dataset().numAttributes(); ++i) {
                if (i == ((Instance)list.get(0)).classIndex()) continue;
                atts.add(((Instance)list.get(0)).dataset().attribute(i).name());
            }
            if (atts.size() > 0) {
                this.m_ComboBoxDimX.setModel(new DefaultComboBoxModel<String>(atts.toArray(new String[0])));
                this.m_ComboBoxDimX.setSelectedIndex(0);
                this.m_ComboBoxDimY.setModel(new DefaultComboBoxModel<String>(atts.toArray(new String[0])));
                this.m_ComboBoxDimY.setSelectedIndex(atts.size() > 1 ? 1 : 0);
            }
        }
        for (Instance item : list) {
            ++this.m_Timestamp;
            ++this.m_SpeedCounter;
            ++this.m_ProcessCounter;
            DataPoint point = new DataPoint(item, Integer.valueOf(this.m_Timestamp));
            this.m_PointBuffer.add(point);
            while (this.m_PointBuffer.size() > this.m_DecayHorizon) {
                this.m_PointBuffer.removeFirst();
            }
            if (this.m_DrawPoints) {
                if (this.m_Timestamp == 1) {
                    this.m_StreamPanel.componentResized(null);
                }
                this.m_StreamPanel.drawPoint(point);
                if (this.m_ProcessCounter % this.m_RedrawInterval == 0) {
                    this.m_StreamPanel.applyDrawDecay((float)this.m_DecayHorizon / (float)this.m_RedrawInterval);
                }
            }
            DenseInstance trainInst = new DenseInstance((InstanceImpl)point);
            if (this.m_ActualClusterer.keepClassLabel()) {
                trainInst.setDataset(point.dataset());
            } else {
                trainInst.deleteAttributeAt(point.classIndex());
            }
            this.m_ActualClusterer.trainOnInstanceImpl((Instance)trainInst);
            if (this.m_ProcessCounter < this.m_ProcessFrequency) continue;
            this.m_ProcessCounter = 0;
            for (DataPoint p : this.m_PointBuffer) {
                p.updateWeight(this.m_Timestamp, this.m_DecayRate);
            }
            this.m_PointArray = new ArrayList<DataPoint>(this.m_PointBuffer);
            this.processClusterings(this.m_PointArray);
        }
    }

    public void clearPanel() {
    }

    protected BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        BaseSplitPane split = new BaseSplitPane(0);
        split.setOneTouchExpandable(true);
        result.add((Component)split, (Object)"Center");
        JPanel panelClusters = new JPanel(new BorderLayout());
        split.setTopComponent((Component)panelClusters);
        this.m_StreamPanel = new StreamPanel();
        this.m_StreamPanel.setGroundTruthLayerVisibility(this.m_DrawGroundTruth);
        this.m_StreamPanel.setMicroLayerVisibility(this.m_DrawMicroClustering);
        this.m_StreamPanel.setMacroLayerVisibility(this.m_DrawClustering);
        this.m_StreamPanel.setPointVisibility(this.m_DrawPoints);
        panelClusters.add((Component)new BaseScrollPane((Component)this.m_StreamPanel), "Center");
        this.m_ComboBoxDimX = new BaseComboBox((Object[])new String[0]);
        this.m_ComboBoxDimX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MOAClusterVisualization.this.m_StreamPanel.setActiveXDim(MOAClusterVisualization.this.m_ComboBoxDimX.getSelectedIndex());
                MOAClusterVisualization.this.m_StreamPanel.repaint();
            }
        });
        this.m_ComboBoxDimY = new BaseComboBox((Object[])new String[0]);
        this.m_ComboBoxDimY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MOAClusterVisualization.this.m_StreamPanel.setActiveYDim(MOAClusterVisualization.this.m_ComboBoxDimY.getSelectedIndex());
                MOAClusterVisualization.this.m_StreamPanel.repaint();
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        panelClusters.add((Component)panel, "West");
        JPanel panel2 = new JPanel(new GridLayout(4, 1));
        panel.add((Component)panel2, "North");
        JLabel label = new JLabel("Dim X");
        label.setDisplayedMnemonic('X');
        label.setLabelFor((Component)this.m_ComboBoxDimX);
        panel2.add(label);
        panel2.add((Component)this.m_ComboBoxDimX);
        label = new JLabel("Dim Y");
        label.setDisplayedMnemonic('Y');
        label.setLabelFor((Component)this.m_ComboBoxDimY);
        panel2.add(label);
        panel2.add((Component)this.m_ComboBoxDimY);
        BaseTabbedPane tabs = new BaseTabbedPane();
        split.setBottomComponent((Component)tabs);
        JPanel panelGraph = new JPanel(new BorderLayout());
        tabs.addTab("Graph", (Component)panelGraph);
        this.m_Graphcanvas = new GraphCanvas();
        this.m_Graphcanvas.setPreferredSize(new Dimension(500, 111));
        BaseScrollPane graphScrollPanel = new BaseScrollPane();
        GroupLayout graphCanvasLayout = new GroupLayout((Container)this.m_Graphcanvas);
        this.m_Graphcanvas.setLayout((LayoutManager)graphCanvasLayout);
        graphCanvasLayout.setHorizontalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 515, Short.MAX_VALUE));
        graphCanvasLayout.setVerticalGroup(graphCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 128, Short.MAX_VALUE));
        graphScrollPanel.setViewportView((Component)this.m_Graphcanvas);
        this.m_Graphcanvas.setGraph(this.m_ActualMeasures[0], null, 0, this.m_ProcessFrequency);
        panelGraph.add((Component)new BaseScrollPane((Component)this.m_Graphcanvas), "Center");
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        panelGraph.add((Component)panel, "West");
        panel2 = new JPanel(new GridLayout(2, 1));
        panel.add((Component)panel2, "North");
        ArrayList<String> measures = new ArrayList<String>();
        for (MeasureCollection measure : this.m_ActualMeasures) {
            for (int i = 0; i < measure.getNumMeasures(); ++i) {
                measures.add(measure.getName(i));
            }
        }
        final BaseComboBox comboBox = new BaseComboBox((Object[])measures.toArray(new String[measures.size()]));
        comboBox.setSelectedIndex(0);
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (comboBox.getSelectedIndex() == -1) {
                    return;
                }
                String name = (String)comboBox.getSelectedItem();
                int sel = -1;
                MeasureCollection coll = null;
                for (MeasureCollection measure : MOAClusterVisualization.this.m_ActualMeasures) {
                    for (int i = 0; i < measure.getNumMeasures(); ++i) {
                        if (!measure.getName(i).equals(name)) continue;
                        coll = measure;
                        sel = i;
                        break;
                    }
                    if (coll != null) break;
                }
                MOAClusterVisualization.this.m_Graphcanvas.setGraph(coll, null, sel, MOAClusterVisualization.this.m_ProcessFrequency);
            }
        });
        label = new JLabel("Measure");
        label.setDisplayedMnemonic('M');
        label.setLabelFor((Component)comboBox);
        panel2.add(label);
        panel2.add((Component)comboBox);
        panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        panelGraph.add((Component)panel, "East");
        panel2 = new JPanel(new GridLayout(4, 1));
        panel.add((Component)panel2, "North");
        BaseButton button = new BaseButton("X", (Icon)GUIHelper.getIcon((String)"zoom_in.png"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MOAClusterVisualization.this.m_Graphcanvas.scaleXResolution(false);
            }
        });
        panel2.add((Component)button);
        button = new BaseButton("X", (Icon)GUIHelper.getIcon((String)"zoom_out.png"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MOAClusterVisualization.this.m_Graphcanvas.scaleXResolution(true);
            }
        });
        panel2.add((Component)button);
        button = new BaseButton("Y", (Icon)GUIHelper.getIcon((String)"zoom_in.png"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MOAClusterVisualization.this.m_Graphcanvas.scaleYResolution(false);
            }
        });
        panel2.add((Component)button);
        button = new BaseButton("Y", (Icon)GUIHelper.getIcon((String)"zoom_out.png"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MOAClusterVisualization.this.m_Graphcanvas.scaleYResolution(true);
            }
        });
        panel2.add((Component)button);
        this.m_LogPanel = new TextPanel();
        this.m_LogPanel.setUpdateParentTitle(false);
        tabs.addTab("Log", (Component)new BaseScrollPane((Component)this.m_LogPanel));
        return result;
    }
}

