/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import java.util.ArrayList;
import java.util.Hashtable;
import moa.clusterers.AbstractClusterer;
import moa.core.Measurement;

public class MOAClustererEvaluation
extends AbstractTransformer {
    private static final long serialVersionUID = 1410487605033307517L;
    public static final String BACKUP_CLUSTERER = "clusterer";
    protected CallableActorReference m_Clusterer;
    protected AbstractClusterer m_ActualClusterer;
    protected int m_OutputInterval;
    protected int m_Count;

    public String globalInfo() {
        return "Evaluates a MOA clusterer using prequential evaluation. With each incoming instance, the clusterer is first evaluated, then trained.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_CLUSTERER, BACKUP_CLUSTERER, (Object)new CallableActorReference("MOAClusterer"));
        this.m_OptionManager.add("output-interval", "outputInterval", (Object)1, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_Count = 0;
        this.m_ActualClusterer = null;
    }

    public void setClusterer(CallableActorReference value) {
        this.m_Clusterer = value;
        this.reset();
    }

    public CallableActorReference getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The name of the callable MOA clusterer to train/evaluate.";
    }

    public void setOutputInterval(int value) {
        this.m_OutputInterval = value;
        this.reset();
    }

    public int getOutputInterval() {
        return this.m_OutputInterval;
    }

    public String outputIntervalTipText() {
        return "The number of tokens to skip before evaluating the clusterer stored in the token (only used when receiving Instance objects).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)BACKUP_CLUSTERER, (Object)this.m_Clusterer);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputInterval", (Object)(this.m_OutputInterval == 1 ? "always" : Integer.valueOf(this.m_OutputInterval)), (String)"/");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Measurement[].class};
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CLUSTERER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualClusterer != null) {
            result.put(BACKUP_CLUSTERER, this.m_ActualClusterer);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_CLUSTERER)) {
            this.m_ActualClusterer = (AbstractClusterer)state.get(BACKUP_CLUSTERER);
            state.remove(BACKUP_CLUSTERER);
        }
        super.restoreState(state);
    }

    protected AbstractClusterer getClustererInstance() {
        MessageCollection errors = new MessageCollection();
        AbstractClusterer result = (AbstractClusterer)CallableActorHelper.getSetup(AbstractClusterer.class, (CallableActorReference)this.m_Clusterer, (Actor)this, (MessageCollection)errors);
        if (result == null && !errors.isEmpty()) {
            this.getLogger().severe(errors.toString());
        }
        return result;
    }

    protected String doExecute() {
        boolean single;
        String result = null;
        if (this.m_ActualClusterer == null) {
            this.m_ActualClusterer = this.getClustererInstance();
            if (this.m_ActualClusterer == null) {
                result = "Failed to located clusterer '" + this.m_Clusterer + "'!";
                return result;
            }
        }
        ArrayList<Instance> data = new ArrayList<Instance>();
        if (this.m_InputToken.getPayload() instanceof Instances) {
            Instances instances = (Instances)this.m_InputToken.getPayload();
            for (int i = 0; i < instances.numInstances(); ++i) {
                data.add(instances.get(i));
            }
            single = false;
        } else {
            data.add((Instance)this.m_InputToken.getPayload());
            single = true;
        }
        for (Instance inst : data) {
            this.m_ActualClusterer.trainOnInstance(inst);
        }
        if (single) {
            ++this.m_Count;
            if (this.m_Count % this.m_OutputInterval == 0) {
                this.m_Count = 0;
                this.m_OutputToken = new Token((Object)this.m_ActualClusterer.getModelMeasurements());
            }
        } else {
            this.m_OutputToken = new Token((Object)this.m_ActualClusterer.getModelMeasurements());
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_ActualClusterer = null;
    }
}

