/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import moa.AbstractMOAObject;
import moa.core.Example;
import moa.core.InstanceExample;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.streams.InstanceStream;
import moa.streams.filters.AddNoiseFilter;
import moa.streams.filters.StreamFilter;
import weka.core.MOAUtils;

public class MOAFilter
extends AbstractTransformer {
    protected ClassOption m_StreamFilter;
    protected StreamFilter m_ActualStreamFilter;
    protected FixedInstanceStream m_FixedInstanceStream;

    public String globalInfo() {
        return "Applies a MOA stream filter to the incoming MOA instances.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "streamFilter", (Object)this.getDefaultOption());
    }

    protected void reset() {
        super.reset();
        this.m_ActualStreamFilter = null;
        this.m_FixedInstanceStream = null;
    }

    protected void initialize() {
        super.initialize();
        this.m_StreamFilter = this.getDefaultOption();
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"filter", this.getCurrentStreamFilter().getClass());
        return result;
    }

    protected ExampleStream getDefaultFilter() {
        return new AddNoiseFilter();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption("filter", 'f', "The MOA stream filter to use from within ADAMS.", StreamFilter.class, this.getDefaultFilter().getClass().getName().replace("moa.streams.filters.", ""), this.getDefaultFilter().getClass().getName());
    }

    public void setStreamFilter(ClassOption value) {
        this.m_StreamFilter.setValueViaCLIString(value.getValueAsCLIString());
        this.reset();
    }

    public ClassOption getStreamFilter() {
        return this.m_StreamFilter;
    }

    public String streamFilterTipText() {
        return "The stream filter to use for filtering the instances.";
    }

    protected StreamFilter getCurrentStreamFilter() {
        return (StreamFilter)MOAUtils.fromOption((ClassOption)this.m_StreamFilter);
    }

    protected String doExecute() {
        if (this.m_ActualStreamFilter == null) {
            this.m_ActualStreamFilter = this.getCurrentStreamFilter();
        }
        if (this.m_FixedInstanceStream == null) {
            this.m_FixedInstanceStream = new FixedInstanceStream();
            this.m_ActualStreamFilter.setInputStream((ExampleStream)this.m_FixedInstanceStream);
        }
        if (this.m_InputToken.hasPayload(Instance.class)) {
            this.m_FixedInstanceStream.setData((Instance)this.m_InputToken.getPayload());
        } else {
            this.m_FixedInstanceStream.setData((Instances)this.m_InputToken.getPayload());
        }
        Instance result = null;
        while (this.m_ActualStreamFilter.hasMoreInstances()) {
            Instance instance = (Instance)this.m_ActualStreamFilter.nextInstance().getData();
            if (result == null) {
                result = instance;
                continue;
            }
            if (result instanceof Instance) {
                Instances instances = new Instances(result.dataset(), 2);
                instances.add(result);
                instances.add(instance);
                result = instances;
                continue;
            }
            ((Instances)result).add(instance);
        }
        this.m_OutputToken = new Token(result);
        return null;
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Instance.class, Instances.class};
    }

    public class FixedInstanceStream
    extends AbstractMOAObject
    implements InstanceStream {
        protected boolean m_Single;
        protected Instance m_Instance;
        protected Instances m_Instances;
        protected int m_Left;

        public void setData(Instance instance) {
            this.m_Single = true;
            this.m_Instance = instance;
            this.m_Instances = null;
            this.m_Left = 1;
        }

        public void setData(Instances instances) {
            this.m_Single = false;
            this.m_Instance = null;
            this.m_Instances = instances;
            this.m_Left = instances.numInstances();
        }

        public InstancesHeader getHeader() {
            if (this.m_Single) {
                return new InstancesHeader(this.m_Instance.dataset());
            }
            return new InstancesHeader(this.m_Instances);
        }

        public long estimatedRemainingInstances() {
            return this.m_Left;
        }

        public boolean hasMoreInstances() {
            return this.m_Left != 0;
        }

        public Example<Instance> nextInstance() {
            if (this.hasMoreInstances()) {
                if (this.m_Single) {
                    this.m_Left = 0;
                    return new InstanceExample(this.m_Instance);
                }
                int next = this.m_Instances.numInstances() - this.m_Left;
                InstanceExample example = new InstanceExample(this.m_Instances.get(next));
                --this.m_Left;
                return example;
            }
            return null;
        }

        public boolean isRestartable() {
            return false;
        }

        public void restart() {
        }

        public void getDescription(StringBuilder sb, int indent) {
        }
    }
}

