/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.source.MOAClassifierSetup;
import adams.flow.source.MOAStream;
import adams.flow.standalone.CallableActors;
import adams.flow.transformer.MOATrainClassifier;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import moa.classifiers.Classifier;
import moa.options.ClassOption;
import moa.streams.ExampleStream;

public class MOAClassifierSetupTest
extends AbstractFlowTest {
    public MOAClassifierSetupTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.arff");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public Actor getActor() {
        CallableActors ga = new CallableActors();
        ClassOption option = new ClassOption("classifier", 'c', "The MOA classifier to use from within ADAMS.", Classifier.class, "trees.DecisionStump", "moa.classifiers.trees.DecisionStump");
        MOAClassifierSetup cls = new MOAClassifierSetup();
        cls.setName("cls");
        cls.setClassifier(option);
        ga.add((Actor)cls);
        ClassOption arffOption = new ClassOption("stream", 's', "The MOA stream generator to use from within ADAMS.", ExampleStream.class, "ArffFileStream -f (" + new TmpFile("iris.arff").getAbsolutePath() + ")", "moa.streams.ArffFileStream");
        MOAStream stream = new MOAStream();
        stream.setNumExamples(-1);
        stream.setStreamGenerator(arffOption);
        MOATrainClassifier cts = new MOATrainClassifier();
        cts.setClassifier(new CallableActorReference("cls"));
        cts.setOutputInterval(150);
        DumpFile df = new DumpFile();
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        Flow flow = new Flow();
        flow.setActors(new Actor[]{ga, stream, cts, df});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(MOAClassifierSetupTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MOAClassifierSetupTest.runTest((Test)MOAClassifierSetupTest.suite());
    }
}

