/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import moa.clusterers.Clusterer;
import moa.clusterers.CobWeb;
import moa.options.ClassOption;
import weka.core.MOAUtils;

public class MOAClustererSetup
extends AbstractSource {
    private static final long serialVersionUID = 2061528297263138851L;
    protected ClassOption m_Clusterer;
    protected Token m_OutputToken;

    public String globalInfo() {
        return "Outputs an instance of the specified MOA clusterer.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("clusterer", "clusterer", (Object)this.getDefaultOption());
    }

    protected void initialize() {
        super.initialize();
        this.m_Clusterer = this.getDefaultOption();
    }

    protected Clusterer getDefaultClusterer() {
        return new CobWeb();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption("clusterer", 'c', "The MOA clusterer to use from within ADAMS.", Clusterer.class, this.getDefaultClusterer().getClass().getName().replace("moa.clusterers.", ""), this.getDefaultClusterer().getClass().getName());
    }

    public void setClusterer(ClassOption value) {
        this.m_Clusterer.setValueViaCLIString(value.getValueAsCLIString());
        this.reset();
    }

    public ClassOption getClusterer() {
        return this.m_Clusterer;
    }

    public String clustererTipText() {
        return "The MOA clusterer to output.";
    }

    protected Clusterer getCurrentClusterer() {
        return (Clusterer)MOAUtils.fromOption((ClassOption)this.m_Clusterer);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"clusterer", this.m_Clusterer != null ? this.getCurrentClusterer().getClass() : null);
    }

    public Class[] generates() {
        return new Class[]{Clusterer.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Clusterer cls = this.getCurrentClusterer();
            this.m_OutputToken = new Token((Object)cls);
        }
        catch (Exception e) {
            this.m_OutputToken = null;
            result = this.handleException("Failed to create copy of clusterer:", e);
        }
        return result;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

