/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import moa.options.ClassOption;
import moa.streams.ExampleStream;
import moa.streams.generators.AgrawalGenerator;
import weka.core.MOAUtils;

public class MOAStream
extends AbstractSource {
    private static final long serialVersionUID = 1862828539481494711L;
    protected ExampleStream m_ActualStreamGenerator;
    protected ClassOption m_StreamGenerator;
    protected int m_NumExamples;
    protected int m_CountExamples;
    protected int m_ChunkSize;

    public String globalInfo() {
        return "Generates artificial data using a MOA stream generator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("stream", "streamGenerator", (Object)this.getDefaultOption());
        this.m_OptionManager.add("num-examples", "numExamples", (Object)10000, (Number)-1, null);
        this.m_OptionManager.add("chunk-size", "chunkSize", (Object)1, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_ActualStreamGenerator = null;
        this.m_CountExamples = 0;
    }

    protected void initialize() {
        super.initialize();
        this.m_StreamGenerator = this.getDefaultOption();
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"evaluator", this.getCurrentStreamGenerator().getClass());
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"numExamples", (Object)(this.m_NumExamples == -1 ? "infinite" : Integer.valueOf(this.m_NumExamples)), (String)"/");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"chunkSize", (Object)(this.m_ChunkSize == 1 ? "one-by-one" : "chunks of " + this.m_ChunkSize), (String)", ");
        return result;
    }

    protected ExampleStream getDefaultGenerator() {
        return new AgrawalGenerator();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption("stream", 's', "The MOA stream generator to use from within ADAMS.", ExampleStream.class, this.getDefaultGenerator().getClass().getName().replace("moa.streams.", ""), this.getDefaultGenerator().getClass().getName());
    }

    public void setStreamGenerator(ClassOption value) {
        this.m_StreamGenerator.setValueViaCLIString(value.getValueAsCLIString());
        this.reset();
    }

    public ClassOption getStreamGenerator() {
        return this.m_StreamGenerator;
    }

    public String streamGeneratorTipText() {
        return "The stream generator to use for generating the weka.core.Instance objects.";
    }

    protected ExampleStream getCurrentStreamGenerator() {
        return (ExampleStream)MOAUtils.fromOption((ClassOption)this.m_StreamGenerator);
    }

    public void setNumExamples(int value) {
        if (value == -1 || value > 0) {
            this.m_NumExamples = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of examples must be -1 for infinite or >0, provided: " + value);
        }
    }

    public int getNumExamples() {
        return this.m_NumExamples;
    }

    public String numExamplesTipText() {
        return "The number of examples to generate; -1 means infinite.";
    }

    public void setChunkSize(int value) {
        if (value >= 1) {
            this.m_ChunkSize = value;
            this.reset();
        } else {
            this.getLogger().warning("Chunk size must be at least 1, provided: " + value);
        }
    }

    public int getChunkSize() {
        return this.m_ChunkSize;
    }

    public String chunkSizeTipText() {
        return "The size of the chunks to create: if 1 then Instance by Instance otherwise an Instances object.";
    }

    public Class[] generates() {
        if (this.m_ChunkSize == 1) {
            return new Class[]{Instance.class};
        }
        return new Class[]{Instances.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            this.m_ActualStreamGenerator = this.getCurrentStreamGenerator();
            this.m_CountExamples = 0;
            InstancesHeader data = this.m_ActualStreamGenerator.getHeader();
            if (data == null) {
                result = "No header obtained from stream generator!";
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate stream: ", e);
        }
        return result;
    }

    public Token output() {
        Token result;
        if (this.m_ChunkSize == 1) {
            result = new Token(this.m_ActualStreamGenerator.nextInstance().getData());
            if (this.m_NumExamples > -1) {
                ++this.m_CountExamples;
            }
        } else {
            Instances data = null;
            int count = 0;
            while (count < this.m_ChunkSize && this.m_ActualStreamGenerator.hasMoreInstances()) {
                ++count;
                Instance inst = (Instance)this.m_ActualStreamGenerator.nextInstance().getData();
                if (data == null) {
                    data = new Instances(inst.dataset(), this.m_ChunkSize);
                }
                data.add(inst);
                if (this.m_NumExamples <= -1) continue;
                ++this.m_CountExamples;
                if (this.m_CountExamples != this.m_NumExamples) continue;
            }
            result = new Token(data);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        boolean maxReached = this.m_NumExamples > -1 && this.m_CountExamples >= this.m_NumExamples;
        return this.m_ActualStreamGenerator != null && !maxReached && this.m_ActualStreamGenerator.hasMoreInstances();
    }
}

