/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.SerializationHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.container.MOAModelContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.yahoo.labs.samoa.instances.Instances;
import java.io.File;

public abstract class AbstractMOAModelReader
extends AbstractTransformer {
    private static final long serialVersionUID = 5684169417381433496L;
    protected boolean m_OutputOnlyModel;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-only-model", "outputOnlyModel", (Object)false);
    }

    public void setOutputOnlyModel(boolean value) {
        this.m_OutputOnlyModel = value;
        this.reset();
    }

    public boolean getOutputOnlyModel() {
        return this.m_OutputOnlyModel;
    }

    public String outputOnlyModelTipText() {
        return "If enabled, only the model will be output instead of a model container.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"outputOnlyModel", (boolean)this.m_OutputOnlyModel, (String)"only model");
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        if (this.m_OutputOnlyModel) {
            return new Class[]{Object.class};
        }
        return new Class[]{MOAModelContainer.class};
    }

    protected String doExecute() {
        Object result = null;
        File file = this.m_InputToken.getPayload() instanceof File ? (File)this.m_InputToken.getPayload() : new PlaceholderFile((String)this.m_InputToken.getPayload());
        try {
            Object[] data = SerializationHelper.readAll((String)file.getAbsolutePath());
            if (this.m_OutputOnlyModel) {
                if (data.length == 1) {
                    this.m_OutputToken = new Token(data[0]);
                } else if (data.length == 2) {
                    this.m_OutputToken = new Token(data[0]);
                } else {
                    result = "Unexpected number of objects in serialized file '" + file + "' (instead of 1 or 2): " + data.length;
                }
            } else {
                MOAModelContainer cont = null;
                if (data.length == 1) {
                    cont = new MOAModelContainer(data[0]);
                } else if (data.length == 2) {
                    cont = new MOAModelContainer(data[0], (Instances)data[1]);
                } else {
                    result = "Unexpected number of objects in serialized file '" + file + "' (instead of 1 or 2): " + data.length;
                }
                if (cont != null) {
                    this.m_OutputToken = new Token((Object)cont);
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to deserialize model data from '" + file + "':", e);
        }
        return result;
    }
}

