/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MOAHelper;
import adams.data.statistics.StatUtils;
import adams.flow.container.MOAPredictionContainer;
import adams.flow.core.AbstractModelLoader;
import adams.flow.core.MOAClassifierModelLoader;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractProcessMOAInstanceWithModel;
import com.yahoo.labs.samoa.instances.Instance;
import moa.classifiers.Classifier;

public class MOAClassifying
extends AbstractProcessMOAInstanceWithModel<Classifier> {
    private static final long serialVersionUID = 5781363684886301467L;
    protected boolean m_OutputInstance;
    protected boolean m_UpdateModel;

    public String globalInfo() {
        return "Uses a serialized MOA model to perform predictions on the data being passed through.\n" + this.m_ModelLoader.automaticOrderInfo() + "\nOptionally, the model can be updated with data being passed through.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-instance", "outputInstance", (Object)false);
        this.m_OptionManager.add("update-model", "updateModel", (Object)false);
    }

    @Override
    protected AbstractModelLoader newModelLoader() {
        return new MOAClassifierModelLoader();
    }

    public void setOutputInstance(boolean value) {
        this.m_OutputInstance = value;
        this.reset();
    }

    public boolean getOutputInstance() {
        return this.m_OutputInstance;
    }

    public String outputInstanceTipText() {
        return "Whether to output weka.core.Instance objects or PredictionContainer objects.";
    }

    public void setUpdateModel(boolean value) {
        this.m_UpdateModel = value;
        this.reset();
    }

    public boolean getUpdateModel() {
        return this.m_UpdateModel;
    }

    public String updateModelTipText() {
        return "Whether to update the model with the Instance (in case its class value isn't missing) after making the prediction.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{MOAPredictionContainer.class, Instance.class};
    }

    @Override
    protected Token processInstance(Instance inst) throws Exception {
        Token result;
        double[] votes = MOAHelper.fixVotes(((Classifier)this.m_Model).getVotesForInstance(inst), inst);
        MOAPredictionContainer cont = new MOAPredictionContainer(inst, StatUtils.maxIndex((double[])votes), votes);
        if (this.m_UpdateModel && !inst.classIsMissing()) {
            ((Classifier)this.m_Model).trainOnInstance(inst);
        }
        if (this.m_OutputInstance) {
            inst = ((Instance)cont.getValue("Instance")).copy();
            inst.setClassValue(((Double)cont.getValue("Classification")).doubleValue());
            result = new Token((Object)inst);
        } else {
            result = new Token((Object)cont.getClone());
        }
        return result;
    }
}

