/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.List;
import moa.core.Measurement;

public class MOAMeasurementPlotGenerator
extends AbstractTransformer {
    private static final long serialVersionUID = 5865235188954357340L;
    protected String m_Prefix;
    protected List<SequencePlotterContainer> m_Containers;
    protected int m_Counter;

    public String globalInfo() {
        return "Generates plot containers from the measurements. The names of the measurements are used as names for the plot containers. It is also possible to prefix the containers with a custom prefix.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_Containers = new ArrayList<SequencePlotterContainer>();
    }

    protected void reset() {
        super.reset();
        this.m_Counter = 0;
        this.m_Containers.clear();
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use for the plot container names.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix);
    }

    public Class[] accepts() {
        return new Class[]{Measurement.class, Measurement[].class};
    }

    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }

    protected String doExecute() {
        String result = null;
        Measurement[] measurements = this.m_InputToken.getPayload() instanceof Measurement ? new Measurement[]{(Measurement)this.m_InputToken.getPayload()} : (Measurement[])this.m_InputToken.getPayload();
        ++this.m_Counter;
        for (int i = 0; i < measurements.length; ++i) {
            Object name = measurements[i].getName();
            if (this.m_Prefix.length() > 0) {
                name = this.m_Prefix + (String)name;
            }
            SequencePlotterContainer cont = new SequencePlotterContainer((String)name, (Comparable)new Double(this.m_Counter), (Comparable)Double.valueOf(measurements[i].getValue()));
            this.m_Containers.add(cont);
        }
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_Containers != null && this.m_Containers.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_Containers.get(0));
        this.m_InputToken = null;
        this.m_Containers.remove(0);
        return result;
    }
}

