/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import java.util.ArrayList;
import java.util.Hashtable;
import moa.classifiers.AbstractClassifier;
import moa.classifiers.Regressor;
import moa.core.Example;
import moa.core.InstanceExample;
import moa.core.Measurement;
import moa.evaluation.BasicRegressionPerformanceEvaluator;
import moa.evaluation.RegressionPerformanceEvaluator;
import moa.options.ClassOption;
import weka.core.MOAUtils;

public class MOARegressorEvaluation
extends AbstractTransformer {
    private static final long serialVersionUID = 1410487605033307517L;
    public static final String BACKUP_REGRESSOR = "regressor";
    protected CallableActorReference m_Regressor;
    protected AbstractClassifier m_ActualRegressor;
    protected ClassOption m_Evaluator;
    protected RegressionPerformanceEvaluator m_ActualEvaluator;
    protected int m_OutputInterval;
    protected int m_Count;

    public String globalInfo() {
        return "Evaluates a MOA regressor using prequential evaluation. With each incoming instance, the regressor is first evaluated, then trained.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add(BACKUP_REGRESSOR, BACKUP_REGRESSOR, (Object)new CallableActorReference("MOARegressor"));
        this.m_OptionManager.add("evaluator", "evaluator", (Object)this.getDefaultOption());
        this.m_OptionManager.add("output-interval", "outputInterval", (Object)1, (Number)1, null);
    }

    protected void reset() {
        super.reset();
        this.m_ActualEvaluator = null;
        this.m_Count = 0;
        this.m_ActualRegressor = null;
    }

    protected void initialize() {
        super.initialize();
        this.m_Evaluator = this.getDefaultOption();
    }

    public void setRegressor(CallableActorReference value) {
        this.m_Regressor = value;
        this.reset();
    }

    public CallableActorReference getRegressor() {
        return this.m_Regressor;
    }

    public String regressorTipText() {
        return "The name of the callable MOA regressor to train/evaluate.";
    }

    protected RegressionPerformanceEvaluator getDefaultEvaluator() {
        return new BasicRegressionPerformanceEvaluator();
    }

    protected ClassOption getDefaultOption() {
        return new ClassOption("evaluator", 'e', "The MOA regressor performance evaluator to use from within ADAMS.", RegressionPerformanceEvaluator.class, this.getDefaultEvaluator().getClass().getName().replace("moa.evaluation.", ""), this.getDefaultEvaluator().getClass().getName());
    }

    public void setEvaluator(ClassOption value) {
        this.m_Evaluator.setValueViaCLIString(value.getValueAsCLIString());
        this.reset();
    }

    public ClassOption getEvaluator() {
        return this.m_Evaluator;
    }

    public String evaluatorTipText() {
        return "The MOA evaluator to use for evaluating a trained MOA regressor.";
    }

    protected RegressionPerformanceEvaluator getCurrentEvaluator() {
        return (RegressionPerformanceEvaluator)MOAUtils.fromOption((ClassOption)this.m_Evaluator);
    }

    public void setOutputInterval(int value) {
        this.m_OutputInterval = value;
        this.reset();
    }

    public int getOutputInterval() {
        return this.m_OutputInterval;
    }

    public String outputIntervalTipText() {
        return "The number of tokens to skip before evaluating the regressor stored in the token (only used when receiving Instance objects).";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)BACKUP_REGRESSOR, (Object)this.m_Regressor);
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"evaluator", this.getCurrentEvaluator().getClass(), (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputInterval", (Object)(this.m_OutputInterval == 1 ? "always" : Integer.valueOf(this.m_OutputInterval)), (String)"/");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Instance.class, Instances.class};
    }

    public Class[] generates() {
        return new Class[]{Measurement[].class};
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_REGRESSOR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_ActualRegressor != null) {
            result.put(BACKUP_REGRESSOR, this.m_ActualRegressor);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_REGRESSOR)) {
            this.m_ActualRegressor = (AbstractClassifier)state.get(BACKUP_REGRESSOR);
            state.remove(BACKUP_REGRESSOR);
        }
        super.restoreState(state);
    }

    protected AbstractClassifier getRegressorInstance() {
        MessageCollection errors = new MessageCollection();
        AbstractClassifier result = (AbstractClassifier)CallableActorHelper.getSetup(Regressor.class, (CallableActorReference)this.m_Regressor, (Actor)this, (MessageCollection)errors);
        if (result == null && !errors.isEmpty()) {
            this.getLogger().severe(errors.toString());
        }
        return result;
    }

    protected String doExecute() {
        boolean single;
        String result = null;
        if (this.m_ActualEvaluator == null) {
            this.m_ActualEvaluator = this.getCurrentEvaluator();
        }
        if (this.m_ActualRegressor == null) {
            this.m_ActualRegressor = this.getRegressorInstance();
            if (this.m_ActualRegressor == null) {
                result = "Failed to located regressor '" + this.m_Regressor + "'!";
                return result;
            }
        }
        ArrayList<Instance> data = new ArrayList<Instance>();
        if (this.m_InputToken.getPayload() instanceof Instances) {
            Instances instances = (Instances)this.m_InputToken.getPayload();
            for (int i = 0; i < instances.numInstances(); ++i) {
                data.add(instances.get(i));
            }
            single = false;
        } else {
            data.add((Instance)this.m_InputToken.getPayload());
            single = true;
        }
        for (Instance inst : data) {
            Instance testInst = inst.copy();
            int trueClass = (int)testInst.classValue();
            testInst.setMissing(testInst.classIndex());
            double[] prediction = this.m_ActualRegressor.getVotesForInstance(testInst);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("trueClass=" + trueClass + ", prediction=" + prediction[0] + ", weight=" + testInst.weight());
            }
            this.m_ActualEvaluator.addResult((Example)new InstanceExample(inst), prediction);
            this.m_ActualRegressor.trainOnInstance(inst);
        }
        if (single) {
            ++this.m_Count;
            if (this.m_Count % this.m_OutputInterval == 0) {
                this.m_Count = 0;
                this.m_OutputToken = new Token((Object)this.m_ActualEvaluator.getPerformanceMeasurements());
            }
        } else {
            this.m_OutputToken = new Token((Object)this.m_ActualEvaluator.getPerformanceMeasurements());
        }
        return result;
    }

    public void wrapUp() {
        super.wrapUp();
        this.m_ActualEvaluator = null;
        this.m_ActualRegressor = null;
    }
}

