/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseMeasureCollection;
import adams.core.option.AbstractOption;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.GUIHelper;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.MultiLineValueDialog;
import adams.gui.goe.MultiSelectionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Array;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import moa.evaluation.MeasureCollection;
import nz.ac.waikato.cms.locator.ClassLocator;

public class BaseMeasureCollectionEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
MultiSelectionEditor {
    protected BaseComboBox<String> m_ComboBoxValue;

    public static String toString(AbstractOption option, Object object) {
        return ((BaseMeasureCollection)((Object)object)).getValue();
    }

    public static Object valueOf(AbstractOption option, String str) {
        return new BaseMeasureCollection(str);
    }

    public String toCustomStringRepresentation(Object obj) {
        return BaseMeasureCollectionEditor.toString(null, obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return new BaseMeasureCollection(str);
    }

    public String getJavaInitializationString() {
        String result = "new " + BaseMeasureCollection.class.getName() + "(\"" + Utils.backQuoteChars((String)this.getValue().toString()) + "\")";
        return result;
    }

    protected String getStringToPaint() {
        return "" + this.getValue();
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        String val = this.getStringToPaint();
        if (val.isEmpty()) {
            val = "[empty]";
        }
        GUIHelper.configureAntiAliasing((Graphics)gfx, (boolean)true);
        int[] offset = GUIHelper.calculateFontOffset((Graphics)gfx, (Rectangle)box);
        gfx.drawString(val, offset[0], offset[1]);
    }

    protected BaseMeasureCollection parse(String s) {
        BaseMeasureCollection result;
        try {
            result = new BaseMeasureCollection(s);
            result.setValue(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(0));
        panelAll.add((Component)panel, "Center");
        List classes = ClassLocator.getSingleton().findNames(MeasureCollection.class, new String[]{"moa.evaluation"});
        for (int i = 0; i < classes.size(); ++i) {
            classes.set(i, ((String)classes.get(i)).replaceAll(".*\\.", ""));
        }
        this.m_ComboBoxValue = new BaseComboBox((Object[])classes.toArray(new String[classes.size()]));
        this.m_ComboBoxValue.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    BaseMeasureCollectionEditor.this.acceptInput();
                } else if (e.getKeyCode() == 27) {
                    e.consume();
                    BaseMeasureCollectionEditor.this.discardInput();
                } else {
                    super.keyPressed(e);
                }
            }
        });
        JLabel label = new JLabel("Measure collection");
        label.setDisplayedMnemonic('M');
        label.setLabelFor((Component)this.m_ComboBoxValue);
        panel.add(label);
        panel.add((Component)this.m_ComboBoxValue);
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelAll.add((Component)panelButtons, "South");
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseMeasureCollectionEditor.this.acceptInput();
            }
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonClose = new BaseButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseMeasureCollectionEditor.this.discardInput();
            }
        });
        panelButtons.add((Component)buttonClose);
        return panelAll;
    }

    protected boolean isValid(String s) {
        return ((BaseMeasureCollection)((Object)this.getValue())).isValid(s);
    }

    protected boolean isUnchanged(String s) {
        return s.equals(((BaseMeasureCollection)((Object)this.getValue())).getValue());
    }

    protected void acceptInput() {
        String s = ((String)this.m_ComboBoxValue.getSelectedItem()).toString();
        if (this.isValid(s) && !this.isUnchanged(s)) {
            this.setValue((Object)this.parse(s));
        }
        this.closeDialog(1);
    }

    protected void discardInput() {
        this.closeDialog(0);
    }

    protected void initForDisplay() {
        super.initForDisplay();
        if (this.m_ComboBoxValue.getSelectedIndex() == -1 || !((String)this.m_ComboBoxValue.getSelectedItem()).toString().equals("" + this.getValue())) {
            this.m_ComboBoxValue.setSelectedItem((Object)("" + this.getValue()));
        }
        this.m_ComboBoxValue.setToolTipText(((BaseMeasureCollection)((Object)this.getValue())).getTipText());
        this.m_ComboBoxValue.grabFocus();
    }

    public Object[] getSelectedObjects(Container parent) {
        MultiLineValueDialog dialog = GUIHelper.getParentDialog((Container)parent) != null ? new MultiLineValueDialog(GUIHelper.getParentDialog((Container)parent)) : new MultiLineValueDialog(GUIHelper.getParentFrame((Container)parent));
        dialog.setInfoText("Enter the measure collection names, one per line:");
        dialog.setLocationRelativeTo((Component)parent);
        dialog.setVisible(true);
        List lines = dialog.getValues();
        Object[] result = (Object[])Array.newInstance(BaseMeasureCollection.class, lines.size());
        for (int i = 0; i < lines.size(); ++i) {
            Array.set(result, i, (Object)this.parse((String)lines.get(i)));
        }
        return result;
    }
}

