/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.container;

import adams.flow.container.AbstractContainer;
import com.mongodb.client.MongoCollection;
import java.util.ArrayList;
import java.util.Iterator;
import org.bson.Document;

public class MongoDbDocumentContainer
extends AbstractContainer {
    private static final long serialVersionUID = -3008555190103834834L;
    public static final String VALUE_COLLECTION = "Collection";
    public static final String VALUE_DOCUMENT = "Document";

    public MongoDbDocumentContainer() {
    }

    public MongoDbDocumentContainer(MongoCollection coll, Document doc) {
        this();
        this.store(VALUE_COLLECTION, coll);
        this.store(VALUE_DOCUMENT, doc);
    }

    protected void initHelp() {
        super.initHelp();
        this.addHelp(VALUE_COLLECTION, "MongoDB collection", MongoCollection.class);
        this.addHelp(VALUE_DOCUMENT, "MongoDB document", Document.class);
    }

    public Iterator<String> names() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(VALUE_COLLECTION);
        result.add(VALUE_DOCUMENT);
        return result.iterator();
    }

    public boolean isValid() {
        return this.hasValue(VALUE_COLLECTION) && this.hasValue(VALUE_DOCUMENT);
    }
}

