/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.db.MongoDbConnection;
import adams.flow.core.Actor;
import adams.flow.core.MongoDbActorUtils;
import adams.flow.source.AbstractSource;
import adams.flow.standalone.DatabaseConnectionProvider;

public abstract class AbstractMongoDbSource
extends AbstractSource {
    private static final long serialVersionUID = -4191676964800948351L;
    protected MongoDbConnection m_DatabaseConnection;

    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = null;
    }

    protected MongoDbConnection getDefaultDatabaseConnection() {
        return MongoDbConnection.getSingleton();
    }

    protected MongoDbConnection getDatabaseConnection() {
        return MongoDbActorUtils.getDatabaseConnection((Actor)this, DatabaseConnectionProvider.class, this.getDefaultDatabaseConnection());
    }

    protected String setUpDatabaseConnection() {
        String result = null;
        if (this.m_DatabaseConnection == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
            if (this.m_DatabaseConnection == null) {
                result = "No database connection available!";
            }
        }
        return result;
    }

    protected abstract String queryDatabase();

    protected String doExecute() {
        String result = this.setUpDatabaseConnection();
        if (result == null) {
            result = this.queryDatabase();
        }
        return result;
    }

    public void wrapUp() {
        this.m_DatabaseConnection = null;
        super.wrapUp();
    }
}

