/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.mongodbcollectionupdate.PassThrough;
import com.mongodb.client.MongoCollection;

public class MongoDbCollectionUpdate
extends AbstractTransformer {
    private static final long serialVersionUID = 296859358661875498L;
    protected adams.flow.transformer.mongodbcollectionupdate.MongoDbCollectionUpdate m_Operation;

    public String globalInfo() {
        return "Updates the collections passing through using the specified operation.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new PassThrough());
    }

    public void setOperation(adams.flow.transformer.mongodbcollectionupdate.MongoDbCollectionUpdate value) {
        this.m_Operation = value;
        this.reset();
    }

    public adams.flow.transformer.mongodbcollectionupdate.MongoDbCollectionUpdate getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The update operation.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)this.m_Operation, (String)"op: ");
    }

    public Class[] accepts() {
        return new Class[]{MongoCollection.class};
    }

    public Class[] generates() {
        return new Class[]{MongoCollection.class};
    }

    protected String doExecute() {
        String result;
        MongoCollection coll = (MongoCollection)this.m_InputToken.getPayload(MongoCollection.class);
        try {
            this.m_Operation.setFlowContext((Actor)this);
            result = this.m_Operation.update(coll);
            this.m_OutputToken = new Token((Object)coll);
        }
        catch (Exception e) {
            result = this.handleException("Failed to update collection, using: " + this.m_Operation, e);
        }
        return result;
    }
}

