/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.MongoDbDocumentContainer;
import adams.flow.core.Actor;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.mongodbfinddocuments.All;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import org.bson.Document;

public class MongoDbFindDocuments
extends AbstractArrayProvider {
    private static final long serialVersionUID = 4673338678018337975L;
    protected adams.flow.transformer.mongodbfinddocuments.MongoDbFindDocuments m_Operation;

    public String globalInfo() {
        return "Locates and forwards documents matching the query.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new All());
    }

    public String outputArrayTipText() {
        return "If enabled, the documents are output as array instead of one-by-one.";
    }

    public void setOperation(adams.flow.transformer.mongodbfinddocuments.MongoDbFindDocuments value) {
        this.m_Operation = value;
        this.reset();
    }

    public adams.flow.transformer.mongodbfinddocuments.MongoDbFindDocuments getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The find operation.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)this.m_Operation, (String)"op: ");
    }

    protected Class getItemClass() {
        return MongoDbDocumentContainer.class;
    }

    public Class[] accepts() {
        return new Class[]{MongoCollection.class};
    }

    protected String doExecute() {
        String result = null;
        MongoCollection coll = (MongoCollection)this.m_InputToken.getPayload(MongoCollection.class);
        this.m_Queue.clear();
        try {
            this.m_Operation.setFlowContext((Actor)this);
            FindIterable<Document> iter = this.m_Operation.find(coll);
            for (Document doc : iter) {
                this.m_Queue.add(new MongoDbDocumentContainer(coll, doc));
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to find documents!", e);
        }
        return result;
    }
}

