/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.MongoDbDocumentContainer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import org.bson.Document;

public class MongoDbGetDocumentValue
extends AbstractTransformer {
    private static final long serialVersionUID = 597361990633872666L;
    protected String m_Key;

    public String globalInfo() {
        return "Obtains the value associated with the specified key from the MongoDB document received as input and forwards it.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", (Object)"");
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The key of the value to retrieve.";
    }

    public Class[] accepts() {
        return new Class[]{MongoDbDocumentContainer.class, Document.class};
    }

    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"key", (Object)this.m_Key, (String)"key: ");
    }

    protected String doExecute() {
        String result = null;
        Document doc = null;
        if (this.m_InputToken.hasPayload(MongoDbDocumentContainer.class)) {
            doc = (Document)((MongoDbDocumentContainer)((Object)this.m_InputToken.getPayload(MongoDbDocumentContainer.class))).getValue("Document");
        } else if (this.m_InputToken.hasPayload(Document.class)) {
            doc = (Document)this.m_InputToken.getPayload(Document.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (doc != null) {
            try {
                Object value = doc.get((Object)this.m_Key);
                if (value != null) {
                    this.m_OutputToken = new Token(value);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to get value for key: " + this.m_Key, e);
            }
        }
        return result;
    }
}

