/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.mongodbdocumentupdate;

import adams.core.MessageCollection;
import adams.core.base.BaseKeyValuePair;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.data.conversion.Conversion;
import adams.data.conversion.ObjectToObject;
import adams.flow.control.Storage;
import adams.flow.control.StorageName;
import adams.flow.transformer.mongodbdocumentupdate.AbstractMongoDbDocumentUpdate;
import adams.flow.transformer.mongodbdocumentupdate.MongoDbDocumentAppend;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import org.bson.Document;

public class AppendStorage
extends AbstractMongoDbDocumentUpdate
implements MongoDbDocumentAppend {
    private static final long serialVersionUID = 3771202579365692102L;
    protected BaseKeyValuePair[] m_KeyValuePairs;
    protected Conversion m_ValueConversion;

    public String globalInfo() {
        return "Appends the document with the specified key-value pairs, with the values representing storage names.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key-value", "keyValuePairs", (Object)new BaseKeyValuePair[0]);
        this.m_OptionManager.add("value-conversion", "valueConversion", (Object)new ObjectToObject());
    }

    public void setKeyValuePairs(BaseKeyValuePair[] value) {
        this.m_KeyValuePairs = value;
        this.reset();
    }

    public BaseKeyValuePair[] getKeyValuePairs() {
        return this.m_KeyValuePairs;
    }

    public String keyValuePairsTipText() {
        return "The key-value pairs to add (the value represents a storage name).";
    }

    public void setValueConversion(Conversion value) {
        this.m_ValueConversion = value;
        this.reset();
    }

    public Conversion getValueConversion() {
        return this.m_ValueConversion;
    }

    public String valueConversionTipText() {
        return "For converting the storage value into the actual type.";
    }

    @Override
    protected String doUpdate(MongoCollection coll, Document doc) {
        String result = null;
        Storage storage = this.getFlowContext().getStorageHandler().getStorage();
        MessageCollection errors = new MessageCollection();
        try {
            for (BaseKeyValuePair pair : this.m_KeyValuePairs) {
                Object val = storage.get(new StorageName(pair.getPairValue()));
                this.m_ValueConversion.setInput(val);
                String msg = this.m_ValueConversion.convert();
                if (msg != null) {
                    errors.add("Failed to convert storage item from " + pair + " using " + this.m_ValueConversion + "\n" + msg);
                    continue;
                }
                val = this.m_ValueConversion.getOutput();
                doc.append(pair.getPairKey(), val);
            }
            if (errors.isEmpty()) {
                coll.deleteOne(Filters.eq((String)"_id", (Object)doc.get((Object)"_id")));
                coll.insertOne((Object)doc);
            }
        }
        catch (Exception e) {
            errors.add(LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to update document!", (Throwable)e));
        }
        if (!errors.isEmpty()) {
            result = errors.toString();
        }
        return result;
    }
}

