/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.CloneHandler;
import adams.core.CompareUtils;
import adams.core.Properties;
import adams.core.base.BasePassword;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingObject;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import adams.db.DatabaseConnectionParameterHandler;
import adams.db.MongoDbConnectionParameters;
import adams.db.MongoDbManager;
import adams.db.MongoDbUrl;
import adams.env.AbstractEnvironment;
import adams.env.Environment;
import adams.event.DatabaseConnectionChangeEvent;
import adams.event.DatabaseConnectionChangeListener;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;

public class MongoDbConnection
extends LoggingObject
implements OptionHandler,
DatabaseConnectionParameterHandler,
Comparable<MongoDbConnection>,
CloneHandler<MongoDbConnection> {
    private static final long serialVersionUID = -3625820307854172417L;
    public static final String PREFIX_CONNECTION = "connection";
    public static final String SUFFIX_COUNT = "count";
    public static final String FILENAME = "MongoDbConnection.props";
    protected static HashMap<Class, AbstractEnvironment> m_Environments = new HashMap();
    private static MongoDbManager m_DatabaseManager = new MongoDbManager("adams");
    protected OptionManager m_OptionManager;
    protected transient HashSet<DatabaseConnectionChangeListener> m_ChangeListeners;
    protected Properties m_Properties;
    protected Hashtable<String, Integer> m_FailedConnectAttempts;
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;
    protected String m_AuthDB;
    protected boolean m_ConnectOnStartUp;
    protected int m_MaxConnectAttempts;
    protected int m_ReconnectWait;
    protected transient MongoClient m_Connection;
    protected boolean m_ConnectionOK;
    protected String m_LastConnectionError;
    protected MongoDbManager m_Owner;
    protected transient AbstractEnvironment m_Environment;

    public MongoDbConnection() {
        this.initialize();
        this.defineOptions();
        this.getOptionManager().setDefaults();
        this.finishInit();
    }

    public MongoDbConnection(String url, String user, BasePassword password, String authDb) {
        this();
        this.setURL(url);
        this.setUser(user);
        this.setPassword(password);
        this.setAuthDB(authDb);
        this.setLoggingLevel(this.getDefaultLoggingLevel());
        if (this.getConnectOnStartUp()) {
            try {
                this.connect();
            }
            catch (Exception e) {
                this.m_LastConnectionError = e.toString();
                this.getLogger().log(Level.SEVERE, "Failed to connect", (Throwable)e);
            }
            if (this.m_ConnectionOK) {
                this.m_LastConnectionError = "";
            }
        }
    }

    protected void initialize() {
        this.m_Connection = null;
        this.m_FailedConnectAttempts = new Hashtable();
        this.m_ConnectionOK = false;
        this.m_LastConnectionError = "";
        this.m_Owner = null;
    }

    protected void finishInit() {
    }

    public void setOwner(MongoDbManager value) {
        this.m_Owner = value;
    }

    public MongoDbManager getOwner() {
        return this.m_Owner;
    }

    protected HashSet<DatabaseConnectionChangeListener> getChangeListeners() {
        if (this.m_ChangeListeners == null) {
            this.m_ChangeListeners = new HashSet();
        }
        return this.m_ChangeListeners;
    }

    protected OptionManager newOptionManager() {
        return new OptionManager((OptionHandler)this);
    }

    public void defineOptions() {
        this.m_OptionManager = this.newOptionManager();
        this.m_OptionManager.add("logging-level", "loggingLevel", (Object)this.getDefaultLoggingLevel());
        this.m_OptionManager.add("url", "URL", (Object)this.getDefaultURL(), false);
        this.m_OptionManager.add("user", "user", (Object)this.getDefaultUser(), false);
        this.m_OptionManager.add("password", "password", (Object)this.getDefaultPassword(), false);
        this.m_OptionManager.add("auth-db", "authDB", (Object)this.getDefaultAuthDB(), false);
        this.m_OptionManager.add("max-attempts", "maxConnectAttempts", (Object)this.getDefaultMaxConnectAttempts());
        this.m_OptionManager.add("reconnect-wait", "reconnectWait", (Object)this.getDefaultReconnectWait());
        this.m_OptionManager.add("connect-on-startup", "connectOnStartUp", (Object)this.getDefaultConnectOnStartUp());
    }

    public OptionManager getOptionManager() {
        if (this.m_OptionManager == null) {
            this.defineOptions();
        }
        return this.m_OptionManager;
    }

    public void cleanUpOptions() {
        if (this.m_OptionManager != null) {
            this.m_OptionManager.cleanUp();
            this.m_OptionManager = null;
        }
    }

    public void destroy() {
        this.cleanUpOptions();
    }

    protected String getDefinitionKey() {
        return "mongo db connection - adams";
    }

    protected AbstractEnvironment createEnvironment() {
        return new Environment();
    }

    protected synchronized AbstractEnvironment getEnvironment() {
        if (this.m_Environment == null) {
            this.m_Environment = m_Environments.get(this.getClass());
        }
        if (this.m_Environment == null) {
            AbstractEnvironment env = this.createEnvironment();
            m_Environments.put(this.getClass(), env);
            this.m_Environment = env;
        }
        return this.m_Environment;
    }

    protected synchronized Properties readProperties() {
        return this.getEnvironment().read(this.getDefinitionKey());
    }

    public synchronized Properties getProperties() {
        if (this.m_Properties == null) {
            this.m_Properties = this.readProperties();
        }
        return this.m_Properties;
    }

    public LoggingLevel getDefaultLoggingLevel() {
        return LoggingLevel.valueOf((String)this.getProperties().getProperty("LoggingLevel", LoggingLevel.WARNING.toString()));
    }

    public void setDefaultLoggingLevel(LoggingLevel value) {
        this.getProperties().setProperty("LoggingLevel", value.toString());
    }

    public void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.getLogger().setLevel(value.getLevel());
    }

    public String loggingLevelTipText() {
        return "The logging level; use FINE or more to have the most detailed output.";
    }

    protected void configureLogger() {
        super.configureLogger();
        if (this.getLoggingLevel() != null) {
            this.getLogger().setLevel(this.getLoggingLevel().getLevel());
        }
    }

    public String getDefaultURL() {
        return this.getProperties().getProperty("URL", "");
    }

    public void setDefaultURL(String value) {
        this.getProperties().setProperty("URL", value);
    }

    public String getURL() {
        return this.m_URL;
    }

    public void setURL(String value) {
        if (this.isConnected()) {
            return;
        }
        if (value == null) {
            return;
        }
        if (value.equals("")) {
            return;
        }
        this.m_URL = value;
        this.m_ConnectionOK = false;
    }

    public String URLTipText() {
        return "The database URL to connect to.";
    }

    public String getDefaultUser() {
        return this.getProperties().getProperty("User", "");
    }

    public void setDefaultUser(String value) {
        this.getProperties().setProperty("User", value);
    }

    public String getUser() {
        return this.m_User;
    }

    public void setUser(String value) {
        if (this.isConnected()) {
            return;
        }
        this.m_User = value;
        this.m_ConnectionOK = false;
    }

    public String userTipText() {
        return "The name of the database user.";
    }

    public BasePassword getDefaultPassword() {
        return new BasePassword(this.getProperties().getProperty("Password", ""));
    }

    public void setDefaultPassword(BasePassword value) {
        this.getProperties().setProperty("Password", value.stringValue());
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public void setPassword(BasePassword value) {
        if (this.isConnected()) {
            return;
        }
        this.m_Password = value;
        this.m_ConnectionOK = false;
    }

    public String passwordTipText() {
        return "The password of the database user.";
    }

    public String getDefaultAuthDB() {
        return this.getProperties().getProperty("AuthDB", "");
    }

    public void setDefaultAuthDB(String value) {
        this.getProperties().setProperty("AuthDB", value);
    }

    public String getAuthDB() {
        return this.m_AuthDB;
    }

    public void setAuthDB(String value) {
        if (this.isConnected()) {
            return;
        }
        this.m_AuthDB = value;
        this.m_ConnectionOK = false;
    }

    public String authDBTipText() {
        return "The name of the authentication database.";
    }

    public int getMaxConnectAttempts() {
        return this.m_MaxConnectAttempts;
    }

    public void setMaxConnectAttempts(int value) {
        if (this.isConnected()) {
            return;
        }
        this.m_MaxConnectAttempts = value;
        this.m_ConnectionOK = false;
    }

    public int getDefaultMaxConnectAttempts() {
        return this.getProperties().getInteger("MaxConnectAttempts", Integer.valueOf(1));
    }

    public String maxConnectAttemptsTipText() {
        return "The maximum number of connection attempts for a driver/URL/user/pw combination.";
    }

    public int getReconnectWait() {
        return this.m_ReconnectWait;
    }

    public void setReconnectWait(int value) {
        if (this.isConnected()) {
            return;
        }
        this.m_ReconnectWait = value;
        this.m_ConnectionOK = false;
    }

    public int getDefaultReconnectWait() {
        return this.getProperties().getInteger("ReconnectWait", Integer.valueOf(10));
    }

    public String reconnectWaitTipText() {
        return "The number of seconds to wait before trying to reconnect.";
    }

    public boolean getDefaultConnectOnStartUp() {
        return this.getProperties().getBoolean("ConnectOnStartup", Boolean.valueOf(false));
    }

    public void setDefaultConnectOnStartUp(boolean value) {
        this.getProperties().setBoolean("ConnectOnStartup", Boolean.valueOf(value));
    }

    public boolean getConnectOnStartUp() {
        return this.m_ConnectOnStartUp;
    }

    public void setConnectOnStartUp(boolean value) {
        if (this.isConnected()) {
            return;
        }
        this.m_ConnectOnStartUp = value;
        this.m_ConnectionOK = false;
    }

    public String connectOnStartUpTipText() {
        return "Whether to connect on startup.";
    }

    public MongoDbConnectionParameters getCurrentConnection() {
        MongoDbConnectionParameters result = this.newConnectionParameters();
        result.setParameter("URL", this.getURL());
        result.setParameter("User", this.getUser());
        result.setParameter("Password", this.getPassword().stringValue());
        result.setParameter("AuthDB", this.getAuthDB());
        result.setParameter("LoggingLevel", "" + this.getLoggingLevel());
        result.setParameter("ConnectOnStartup", "" + this.getConnectOnStartUp());
        return result;
    }

    protected String getFailedConnectAttemptKey(String url, String user, BasePassword password, String authDB) {
        String result = url + "\t" + user + "\t" + password + "\t" + authDB;
        return result;
    }

    protected int getFailedConnectAttempt(String url, String user, BasePassword password, String authDB) {
        String key = this.getFailedConnectAttemptKey(url, user, password, authDB);
        int result = !this.m_FailedConnectAttempts.containsKey(key) ? 0 : this.m_FailedConnectAttempts.get(key);
        return result;
    }

    protected void incFailedConnectAttempt(String url, String user, BasePassword password, String authDB) {
        String key = this.getFailedConnectAttemptKey(url, user, password, authDB);
        int count = this.getFailedConnectAttempt(url, user, password, authDB);
        this.m_FailedConnectAttempts.put(key, ++count);
        this.m_LastConnectionError = "Failed connection attempt: URL=" + url + ", user=" + user + ", pw=" + password + ", authdb=" + authDB;
    }

    protected void resetFailedConnectAttempt(String url, String user, BasePassword password, String authDB) {
        String key = this.getFailedConnectAttemptKey(url, user, password, authDB);
        this.m_FailedConnectAttempts.put(key, 0);
        this.m_LastConnectionError = "";
    }

    public String getLastConnectionError() {
        return this.m_LastConnectionError;
    }

    public synchronized MongoClient getConnection(boolean keepTrying) {
        if (!this.m_ConnectionOK) {
            if (keepTrying) {
                if (!this.tryConnection()) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return this.m_Connection;
    }

    protected boolean tryConnection() {
        if (LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.FINE)) {
            this.getLogger().log(Level.FINE, "tryConnection request originated from:\n" + LoggingHelper.getStackTrace((int)-1));
        }
        while (!this.m_ConnectionOK) {
            if (this.m_LastConnectionError.indexOf("CommunicationsException") > -1) {
                return false;
            }
            if (this.getFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password, this.m_AuthDB) >= this.m_MaxConnectAttempts) {
                this.m_LastConnectionError = "Too many failed connection attempts: URL=" + this.m_URL + ", user=" + this.m_User + ", pw=" + this.m_Password;
                return false;
            }
            try {
                this.connect();
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to connect", (Throwable)e);
            }
            if (this.m_ConnectionOK) continue;
            try {
                for (int i = 0; i < this.m_ReconnectWait * 10; ++i) {
                    this.wait(100L);
                    if (this.getFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password, this.m_AuthDB) < this.m_MaxConnectAttempts) continue;
                    this.m_LastConnectionError = "Too many failed connection attempts: URL=" + this.m_URL + ", user=" + this.m_User + ", pw=" + this.m_Password;
                    return false;
                }
            }
            catch (InterruptedException e) {
                this.getLogger().log(Level.SEVERE, "Interrupted", (Throwable)e);
            }
        }
        return true;
    }

    public boolean isConnectionOK() {
        return this.m_ConnectionOK;
    }

    public synchronized boolean isConnected() {
        boolean result;
        boolean bl = result = this.m_Connection != null;
        if (result) {
            try {
                this.m_Connection.getAddress();
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
            if (!result) {
                this.m_Connection = null;
            }
        }
        return result;
    }

    public synchronized boolean retryConnect() {
        this.disconnect();
        try {
            return this.connect();
        }
        catch (Exception e) {
            return false;
        }
    }

    public synchronized boolean connect() throws Exception {
        this.m_LastConnectionError = "";
        this.getLogger().info("connecting: " + this.m_URL);
        if (LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.FINE)) {
            this.getLogger().log(Level.FINE, "Connection request originated from:\n" + LoggingHelper.getStackTrace((int)-1));
        }
        if (!this.isConnected()) {
            if (this.getFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password, this.m_AuthDB) >= this.getMaxConnectAttempts()) {
                this.m_ConnectionOK = false;
                this.m_LastConnectionError = "Maximum number of connection attempts reached: URL=" + this.m_URL + ", user=" + this.m_User + ", pw=" + this.m_Password.getMaskedValue();
                this.getLogger().severe(this.m_LastConnectionError);
                return false;
            }
            try {
                MongoCredential cred = null;
                MongoDbUrl url = new MongoDbUrl(this.m_URL);
                if (!this.m_User.isEmpty()) {
                    cred = MongoCredential.createCredential((String)this.m_User, (String)url.uriValue().getDatabase(), (char[])this.m_Password.stringValue().toCharArray());
                }
                this.m_Connection = cred == null ? new MongoClient(url.uriValue()) : new MongoClient(new ServerAddress(url.hostValue(), url.portValue()), MongoClientOptions.builder().build());
            }
            catch (Exception e) {
                this.m_Connection = null;
                this.m_LastConnectionError = e.toString();
            }
            if (this.m_Connection == null) {
                this.getLogger().severe("Cannot connect: " + this.m_LastConnectionError + "\n- URL: " + this.m_URL + "\n- user: " + this.m_User + "\n- pw: " + this.m_Password.getMaskedValue() + "\n");
                this.incFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password, this.m_AuthDB);
                return false;
            }
        }
        this.m_ConnectionOK = this.isConnected();
        if (!this.m_ConnectionOK) {
            this.incFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password, this.m_AuthDB);
        } else {
            this.resetFailedConnectAttempt(this.m_URL, this.m_User, this.m_Password, this.m_AuthDB);
        }
        this.notifyChangeListeners(new DatabaseConnectionChangeEvent((Object)this, DatabaseConnectionChangeEvent.EventType.CONNECT));
        return this.m_ConnectionOK;
    }

    public synchronized boolean disconnect() {
        if (LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.FINE)) {
            this.getLogger().log(Level.FINE, "Disconnect request originated from:", (Object)LoggingHelper.getStackTrace((int)-1));
        }
        if (this.m_Connection != null) {
            this.getLogger().info("disconnecting: " + this.m_URL);
            try {
                this.m_Connection.close();
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to close connection");
                this.m_Connection = null;
                return false;
            }
            this.m_Connection = null;
        }
        this.m_ConnectionOK = false;
        this.notifyChangeListeners(new DatabaseConnectionChangeEvent((Object)this, DatabaseConnectionChangeEvent.EventType.DISCONNECT));
        return true;
    }

    public MongoDbConnectionParameters newConnectionParameters() {
        return new MongoDbConnectionParameters();
    }

    public MongoDbConnectionParameters getDefaultConnection() {
        MongoDbConnectionParameters result = this.newConnectionParameters();
        result.setParameter("URL", this.getDefaultURL());
        result.setParameter("User", this.getDefaultUser());
        result.setParameter("Password", this.getDefaultPassword().stringValue());
        result.setParameter("AuthDB", this.getDefaultAuthDB());
        result.setParameter("LoggingLevel", "" + this.getDefaultLoggingLevel());
        result.setParameter("ConnectOnStartup", "" + this.getDefaultConnectOnStartUp());
        return result;
    }

    public List<MongoDbConnectionParameters> getConnections() {
        ArrayList<MongoDbConnectionParameters> result = new ArrayList<MongoDbConnectionParameters>();
        result.add(this.getDefaultConnection());
        Properties props = this.getProperties();
        if (props.hasKey("connection.count")) {
            int count = props.getInteger("connection.count", Integer.valueOf(0));
            for (int i = 0; i < count; ++i) {
                String prefix = "connection." + i + ".";
                MongoDbConnectionParameters conn = MongoDbConnectionParameters.forName(props.getProperty(prefix + "Class"));
                Enumeration keys = props.propertyNames("connection\\." + i + "\\..*");
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    conn.setParameter(key.substring(prefix.length()), props.getProperty(key));
                }
                if (result.contains(conn)) continue;
                result.add(conn);
            }
        }
        return result;
    }

    public boolean addConnection(MongoDbConnectionParameters conn) {
        List<MongoDbConnectionParameters> connections = this.getConnections();
        if (connections.contains(conn)) {
            connections.remove(conn);
        }
        connections.add(0, conn);
        Properties props = this.getProperties();
        props.removeWithPrefix(PREFIX_CONNECTION);
        props.setInteger("connection.count", Integer.valueOf(connections.size()));
        for (int i = 0; i < connections.size(); ++i) {
            props.setProperty("connection." + i + "." + "Class", conn.getClass().getName());
            for (String param : connections.get(i).parameters()) {
                String value = connections.get(i).getParameter(param);
                props.setProperty("connection." + i + "." + param, value);
            }
        }
        boolean result = this.updateConnections();
        if (!result) {
            System.err.println("Error adding connection: " + conn);
        }
        return result;
    }

    public synchronized boolean makeDefaultConnection(MongoDbConnectionParameters conn) {
        this.setDefaultURL(conn.getURL());
        this.setDefaultUser(conn.getUser());
        this.setDefaultPassword(conn.getPassword());
        this.setDefaultAuthDB(conn.getAuthDB());
        this.setDefaultLoggingLevel(conn.getLoggingLevel());
        this.setDefaultConnectOnStartUp(conn.getConnectOnStartUp());
        boolean result = this.updateConnections();
        if (!result) {
            System.err.println("Error setting default connection: " + conn);
        } else if (this.getOwner() != null) {
            this.getOwner().setDefault(this.getDefaultConnection().toDatabaseConnection(this.getClass()));
        }
        return result;
    }

    public boolean updateConnections() {
        return this.getEnvironment().write(this.getDefinitionKey(), this.getProperties());
    }

    protected void outputChangeListeners() {
        this.getLogger().fine("DB change listeners: #" + this.getChangeListeners().size());
        for (DatabaseConnectionChangeListener list : this.getChangeListeners()) {
            this.getLogger().fine("  " + list.getClass().getName());
        }
    }

    public void addChangeListener(DatabaseConnectionChangeListener l) {
        this.getChangeListeners().add(l);
        if (this.isLoggingEnabled()) {
            this.outputChangeListeners();
        }
    }

    public void removeChangeListener(DatabaseConnectionChangeListener l) {
        this.getChangeListeners().remove(l);
        if (this.isLoggingEnabled()) {
            this.outputChangeListeners();
        }
    }

    public synchronized void notifyChangeListeners(DatabaseConnectionChangeEvent e) {
        int count = 0;
        DatabaseConnectionChangeListener[] listeners = this.getChangeListeners().toArray(new DatabaseConnectionChangeListener[this.getChangeListeners().size()]);
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("Notifying about: " + e.getType());
        }
        for (DatabaseConnectionChangeListener listener : listeners) {
            ++count;
            long start = System.currentTimeMillis();
            listener.databaseConnectionStateChanged(e);
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().fine(count + "/" + this.getChangeListeners().size() + ": " + listener.getClass().getName() + " (" + (System.currentTimeMillis() - start) + "ms)");
        }
    }

    @Override
    public int compareTo(MongoDbConnection o) {
        if (o == null) {
            return 1;
        }
        int result = CompareUtils.compare((Comparable)((Object)this.getURL()), (Comparable)((Object)o.getURL()));
        if (result == 0) {
            result = CompareUtils.compare((Comparable)((Object)this.getUser()), (Comparable)((Object)o.getUser()));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof MongoDbConnection) {
            return this.compareTo((MongoDbConnection)o) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (this.getURL() + "\t" + this.getUser()).hashCode();
    }

    public synchronized MongoDbConnection getClone() {
        MongoDbConnection result = (MongoDbConnection)OptionUtils.shallowCopy((OptionHandler)this, (boolean)false);
        if (this.isConnected()) {
            result.m_Connection = this.m_Connection;
            result.m_ConnectionOK = this.m_ConnectionOK;
            result.m_LastConnectionError = this.m_LastConnectionError;
        }
        result.getChangeListeners().addAll(this.getChangeListeners());
        if (this.getOwner() != null) {
            this.getOwner().add(result);
        }
        return result;
    }

    public String toStringShort() {
        String result = this.getURL().replaceAll(".*:\\/\\/", "").replaceAll("\\..*\\/", "/");
        return result;
    }

    public String toString() {
        String result = "url=" + this.getURL();
        result = result + ", user=" + this.getUser();
        result = result + ", password=" + this.getPassword();
        result = result + ", authDB=" + this.getAuthDB();
        result = result + ", connected=" + this.isConnected();
        result = result + ", #listeners=" + this.getChangeListeners().size();
        return result;
    }

    public String toCommandLine() {
        return OptionUtils.getCommandLine((Object)this);
    }

    public static synchronized MongoDbConnection getSingleton(String url, String user, BasePassword password, String authDB) {
        if (!m_DatabaseManager.has(url, user, password, authDB)) {
            m_DatabaseManager.add(new MongoDbConnection(url, user, password, authDB));
        } else if (!m_DatabaseManager.get(url, user, password, authDB).isConnected()) {
            try {
                m_DatabaseManager.get(url, user, password, authDB).connect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return m_DatabaseManager.get(url, user, password, authDB);
    }

    public static synchronized MongoDbConnection getSingleton() {
        return m_DatabaseManager.getDefault();
    }

    public static MongoDbManager getDatabaseManager() {
        return m_DatabaseManager;
    }

    static {
        MongoDbConnection dbcon = new MongoDbConnection();
        m_DatabaseManager.setDefault(MongoDbConnection.getSingleton(dbcon.getURL(), dbcon.getUser(), dbcon.getPassword(), dbcon.getAuthDB()));
    }
}

