/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.CloneHandler;
import adams.core.base.BasePassword;
import adams.core.logging.LoggingLevel;
import adams.db.MongoDbConnection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MongoDbConnectionParameters
implements Serializable,
Comparable<MongoDbConnectionParameters>,
CloneHandler<MongoDbConnectionParameters> {
    private static final long serialVersionUID = -1414581492377334939L;
    public static final String PARAM_CLASS = "Class";
    public static final String PARAM_URL = "URL";
    public static final String PARAM_USER = "User";
    public static final String PARAM_PASSWORD = "Password";
    public static final String PARAM_AUTHDB = "AuthDB";
    public static final String PARAM_LOGGINGLEVEL = "LoggingLevel";
    public static final String PARAM_CONNECTONSTARTUP = "ConnectOnStartup";
    protected String m_URL;
    protected String m_User;
    protected BasePassword m_Password;
    protected String m_AuthDB;
    protected LoggingLevel m_LoggingLevel;
    protected boolean m_ConnectOnStartUp;

    public MongoDbConnectionParameters() {
        this.initialize();
    }

    protected void initialize() {
        this.m_URL = "";
        this.m_User = "";
        this.m_Password = new BasePassword();
        this.m_AuthDB = "";
        this.m_LoggingLevel = LoggingLevel.OFF;
        this.m_ConnectOnStartUp = false;
    }

    public String getURL() {
        return this.m_URL;
    }

    public String getUser() {
        return this.m_User;
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String getAuthDB() {
        return this.m_AuthDB;
    }

    public LoggingLevel getLoggingLevel() {
        return this.m_LoggingLevel;
    }

    public boolean getConnectOnStartUp() {
        return this.m_ConnectOnStartUp;
    }

    public List<String> parameters() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(PARAM_CLASS);
        result.add(PARAM_URL);
        result.add(PARAM_USER);
        result.add(PARAM_PASSWORD);
        result.add(PARAM_AUTHDB);
        result.add(PARAM_LOGGINGLEVEL);
        result.add(PARAM_CONNECTONSTARTUP);
        return result;
    }

    public String getParameter(String key) {
        if (key.equals(PARAM_CLASS)) {
            return this.getClass().getName();
        }
        if (key.equals(PARAM_URL)) {
            return this.m_URL;
        }
        if (key.equals(PARAM_USER)) {
            return this.m_User;
        }
        if (key.equals(PARAM_PASSWORD)) {
            return this.m_Password.stringValue();
        }
        if (key.equals(PARAM_AUTHDB)) {
            return this.m_AuthDB;
        }
        if (key.equals(PARAM_LOGGINGLEVEL)) {
            return "" + this.m_LoggingLevel;
        }
        if (key.equals(PARAM_CONNECTONSTARTUP)) {
            return "" + this.m_ConnectOnStartUp;
        }
        return null;
    }

    public void setParameter(String key, String value) {
        if (key.equals(PARAM_CLASS)) {
            // empty if block
        }
        if (key.equals(PARAM_URL)) {
            this.m_URL = value;
        } else if (key.equals(PARAM_USER)) {
            this.m_User = value;
        } else if (key.equals(PARAM_PASSWORD)) {
            this.m_Password = new BasePassword(value);
        } else if (key.equals(PARAM_AUTHDB)) {
            this.m_AuthDB = value;
        } else if (key.equals(PARAM_LOGGINGLEVEL)) {
            this.m_LoggingLevel = LoggingLevel.valueOf((String)value);
        } else if (key.equals(PARAM_CONNECTONSTARTUP)) {
            this.m_ConnectOnStartUp = Boolean.parseBoolean(value);
        }
    }

    protected MongoDbConnectionParameters newInstance() {
        return new MongoDbConnectionParameters();
    }

    public MongoDbConnectionParameters getClone() {
        MongoDbConnectionParameters result = this.newInstance();
        for (String key : this.parameters()) {
            result.setParameter(key, this.getParameter(key));
        }
        return result;
    }

    @Override
    public int compareTo(MongoDbConnectionParameters o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        for (String key : this.parameters()) {
            String oThis = this.getParameter(key);
            String oOther = o.getParameter(key);
            if (oOther == null) {
                result = 1;
            } else if (oThis instanceof Comparable) {
                result = ((Comparable)((Object)oThis)).compareTo(oOther);
            }
            if (result == 0) continue;
            break;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MongoDbConnectionParameters) {
            return this.compareTo((MongoDbConnectionParameters)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (this.m_URL + "\t" + this.m_User + "\t" + this.m_Password + "\t" + this.m_AuthDB).hashCode();
    }

    public String toString() {
        return this.m_URL.replaceAll(".*\\/\\/", "");
    }

    public MongoDbConnection toDatabaseConnection(Class dbcon) {
        MongoDbConnection result;
        try {
            result = (MongoDbConnection)dbcon.newInstance();
            result.setURL(this.getURL());
            result.setUser(this.getUser());
            result.setPassword(this.getPassword());
            result.setAuthDB(this.getAuthDB());
            result.setLoggingLevel(this.getLoggingLevel());
            result.setConnectOnStartUp(this.getConnectOnStartUp());
            MongoDbConnection.getDatabaseManager().add(result);
        }
        catch (Exception e) {
            System.err.println("Failed to create MongoDB connection object:");
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static MongoDbConnectionParameters forName(String classname) {
        MongoDbConnectionParameters result;
        try {
            result = (MongoDbConnectionParameters)Class.forName(classname).newInstance();
        }
        catch (Exception e) {
            result = new MongoDbConnectionParameters();
        }
        return result;
    }
}

