/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.db.MongoDbConnection;
import adams.flow.condition.bool.AbstractBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.MongoDbActorUtils;
import adams.flow.core.Token;
import adams.flow.standalone.DatabaseConnectionProvider;

public abstract class AbstractMongoDbBooleanCondition
extends AbstractBooleanCondition {
    private static final long serialVersionUID = -2563430699960393494L;
    protected MongoDbConnection m_DatabaseConnection;
    protected boolean m_DatabaseConnectionUpdated;

    protected void initialize() {
        super.initialize();
        this.m_DatabaseConnection = this.getDefaultDatabaseConnection();
    }

    protected void reset() {
        super.reset();
        this.m_DatabaseConnectionUpdated = false;
    }

    protected MongoDbConnection getDefaultDatabaseConnection() {
        return MongoDbConnection.getSingleton();
    }

    protected MongoDbConnection getConnection(Actor actor) {
        return MongoDbActorUtils.getDatabaseConnection(actor, DatabaseConnectionProvider.class, this.getDefaultDatabaseConnection());
    }

    protected String preEvaluate(Actor owner, Token token) {
        String result = super.preEvaluate(owner, token);
        if (result == null && !this.m_DatabaseConnectionUpdated) {
            this.m_DatabaseConnectionUpdated = true;
            if (owner instanceof Actor) {
                this.m_DatabaseConnection = this.getConnection(owner);
            }
        }
        return result;
    }
}

