/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.db.MongoDbUrl;
import adams.flow.condition.bool.AbstractMongoDbBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import java.util.logging.Level;

public class MongoDbCollectionExists
extends AbstractMongoDbBooleanCondition {
    private static final long serialVersionUID = 6846151121506219847L;
    protected String m_Collection;

    public String globalInfo() {
        return "Returns 'true' if the specified collection exists in the current database context.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("collection", "collection", (Object)"");
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"collection", (Object)this.m_Collection, (String)"coll: ");
    }

    public void setCollection(String value) {
        this.m_Collection = value;
        this.reset();
    }

    public String getCollection() {
        return this.m_Collection;
    }

    public String collectionTipText() {
        return "The name of the collection to check.";
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    protected boolean doEvaluate(Actor owner, Token token) {
        boolean result = false;
        try {
            MongoDbUrl url = new MongoDbUrl(this.m_DatabaseConnection.getURL());
            for (String coll : this.m_DatabaseConnection.getConnection(true).getDatabase(url.uriValue().getDatabase()).listCollectionNames()) {
                if (!this.m_Collection.equals(coll)) continue;
                result = true;
                break;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to iterate collections!", (Throwable)e);
        }
        return result;
    }
}

