/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.bool;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.db.MongoDbUrl;
import adams.flow.condition.bool.AbstractMongoDbBooleanCondition;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import java.util.logging.Level;

public class MongoDbDocumentExists
extends AbstractMongoDbBooleanCondition {
    private static final long serialVersionUID = 6846151121506219847L;
    protected String m_Collection;
    protected String m_ID;

    public String globalInfo() {
        return "Returns 'true' if a document with that ID exists.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("collection", "collection", (Object)"");
        this.m_OptionManager.add("ID", "ID", (Object)"");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"collection", (Object)this.m_Collection, (String)"coll: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"ID", (Object)this.m_ID, (String)", ID: ");
        return result;
    }

    public void setCollection(String value) {
        this.m_Collection = value;
        this.reset();
    }

    public String getCollection() {
        return this.m_Collection;
    }

    public String collectionTipText() {
        return "The name of the collection to check.";
    }

    public void setID(String value) {
        this.m_ID = value;
        this.reset();
    }

    public String getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The ID of the document to check.";
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    protected boolean doEvaluate(Actor owner, Token token) {
        boolean result = false;
        try {
            MongoDbUrl url = new MongoDbUrl(this.m_DatabaseConnection.getURL());
            MongoCollection coll = this.m_DatabaseConnection.getConnection(true).getDatabase(url.uriValue().getDatabase()).getCollection(this.m_Collection);
            FindIterable docs = coll.find(Filters.eq((String)"_id", (Object)this.m_ID));
            MongoCursor iter = docs.iterator();
            while (iter.hasNext()) {
                iter.next();
                result = true;
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to locate document in collection '" + this.m_Collection + "' with ID '" + this.m_ID + "'!", (Throwable)e);
        }
        return result;
    }
}

