/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.flow.source.AbstractMongoDbArrayProvider;

public class MongoDbListDatabases
extends AbstractMongoDbArrayProvider {
    private static final long serialVersionUID = 5792094981880622147L;
    protected BaseRegExp m_RegExp;

    public String globalInfo() {
        return "Lists the names of the available databases that match the regular expression.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"regExp", (BaseRegExp)this.m_RegExp, (String)"regexp: ");
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression that the collection names must match.";
    }

    protected Class getItemClass() {
        return String.class;
    }

    public String outputArrayTipText() {
        return "If enabled, the names are output as an array rather than one-by-one.";
    }

    @Override
    protected String queryDatabase() {
        String result = null;
        this.m_Queue.clear();
        try {
            for (String coll : this.m_DatabaseConnection.getConnection(true).listDatabaseNames()) {
                if (!this.m_RegExp.isMatch(coll)) continue;
                this.m_Queue.add(coll);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to list databases!", e);
        }
        return result;
    }
}

