/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.db.MongoDbUrl;
import adams.flow.core.Token;
import adams.flow.source.AbstractMongoDbSimpleSource;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;

public class MongoDbNewCollection
extends AbstractMongoDbSimpleSource {
    private static final long serialVersionUID = 5792094981880622147L;
    protected String m_Collection;

    public String globalInfo() {
        return "Creates a new collection and forwards it.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("collection", "collection", (Object)"");
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"collection", (Object)this.m_Collection, (String)"coll: ");
    }

    public void setCollection(String value) {
        this.m_Collection = value;
        this.reset();
    }

    public String getCollection() {
        return this.m_Collection;
    }

    public String collectionTipText() {
        return "The name of the collection to create.";
    }

    public Class[] generates() {
        return new Class[]{MongoCollection.class};
    }

    @Override
    protected String queryDatabase() {
        String result = null;
        try {
            MongoDbUrl url = new MongoDbUrl(this.m_DatabaseConnection.getURL());
            String database = url.uriValue().getDatabase();
            MongoClient mongoclient = this.m_DatabaseConnection.getConnection(true);
            if (mongoclient == null) {
                result = "Failed to obtain connection: " + this.m_DatabaseConnection.getURL();
            } else {
                MongoDatabase mongodb = mongoclient.getDatabase(database);
                mongodb.createCollection(this.m_Collection);
                this.m_OutputToken = new Token((Object)mongodb.getCollection(this.m_Collection));
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to create collection: " + this.m_Collection, e);
        }
        return result;
    }
}

