/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.mongodbcollectionupdate;

import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.flow.transformer.mongodbcollectionupdate.AbstractMongoDbCollectionUpdate;
import adams.flow.transformer.mongodbdocumentupdate.MongoDbDocumentAppend;
import com.mongodb.client.MongoCollection;
import org.bson.Document;

public class AddDocument
extends AbstractMongoDbCollectionUpdate {
    private static final long serialVersionUID = 3771202579365692102L;
    protected String m_ID;
    protected MongoDbDocumentAppend[] m_Updates;

    public String globalInfo() {
        return "Adds a new document with the given ID to the document.\nThe document gets filled with the specified key-value pairs.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("id", "ID", (Object)"");
        this.m_OptionManager.add("update", "updates", (Object)new MongoDbDocumentAppend[0]);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"ID", (Object)(this.m_ID.isEmpty() ? "-auto-" : this.m_ID), (String)"ID: ");
    }

    public void setID(String value) {
        this.m_ID = value;
        this.reset();
    }

    public String getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The ID to use for the document.";
    }

    public void setUpdates(MongoDbDocumentAppend[] value) {
        this.m_Updates = value;
        this.reset();
    }

    public MongoDbDocumentAppend[] getUpdates() {
        return this.m_Updates;
    }

    public String updatesTipText() {
        return "The for updating the document.";
    }

    @Override
    protected String doUpdate(MongoCollection coll) {
        String result = null;
        try {
            Document doc = this.m_ID.isEmpty() ? new Document() : new Document("_id", (Object)this.m_ID);
            coll.insertOne((Object)doc);
            for (MongoDbDocumentAppend update : this.m_Updates) {
                update.setFlowContext(this.getFlowContext());
                result = update.update(coll, doc);
                if (result == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to add document!", (Throwable)e);
        }
        return result;
    }
}

