/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.mongodbdocumentupdate;

import adams.core.base.BaseString;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.flow.transformer.mongodbdocumentupdate.AbstractMongoDbDocumentUpdate;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import org.bson.Document;

public class Remove
extends AbstractMongoDbDocumentUpdate {
    private static final long serialVersionUID = 3771202579365692102L;
    protected BaseString[] m_Keys;

    public String globalInfo() {
        return "Removes the specified keys from the document.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "keys", (Object)new BaseString[0]);
    }

    public void setKeys(BaseString[] value) {
        this.m_Keys = value;
        this.reset();
    }

    public BaseString[] getKeys() {
        return this.m_Keys;
    }

    public String keysTipText() {
        return "The keys to remove.";
    }

    @Override
    protected String doUpdate(MongoCollection coll, Document doc) {
        String result = null;
        try {
            for (BaseString key : this.m_Keys) {
                doc.remove((Object)key.getValue());
            }
            coll.deleteOne(Filters.eq((String)"_id", (Object)doc.get((Object)"_id")));
            coll.insertOne((Object)doc);
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to remove key(s)!", (Throwable)e);
        }
        return result;
    }
}

