/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.ClassLister;
import adams.core.StatusMessageHandler;
import adams.core.logging.LoggingLevel;
import adams.db.MongoDbConnection;
import adams.db.MongoDbConnectionParameters;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTextField;
import adams.gui.core.GUIHelper;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MongoDbConnectionPanel
extends BasePanel
implements StatusMessageHandler,
Comparable<MongoDbConnectionPanel> {
    private static final long serialVersionUID = -8207475445903090661L;
    protected MongoDbConnectionPanel m_Self;
    protected BaseComboBox m_ComboBoxConnections;
    protected BaseTextField m_TextURL;
    protected BaseTextField m_TextUser;
    protected JPasswordField m_TextPassword;
    protected BaseCheckBox m_CheckBoxShowPassword;
    protected BaseTextField m_TextAuthDB;
    protected BaseComboBox m_ComboBoxLoggingLevel;
    protected BaseCheckBox m_CheckBoxConnectOnStartUp;
    protected BaseButton m_ButtonMakeDefault;
    protected BaseButton m_ButtonConnect;
    protected JLabel m_LabelStatus;
    protected ParameterPanel m_PanelParameters;
    protected HashSet<ChangeListener> m_ChangeListeners;

    protected void initialize() {
        super.initialize();
        this.m_Self = this;
        this.m_ChangeListeners = new HashSet();
    }

    protected MongoDbConnection getDefaultDatabaseConnection() {
        return MongoDbConnection.getSingleton();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelParameters = new ParameterPanel();
        this.add((Component)this.m_PanelParameters, "North");
        this.m_ComboBoxConnections = new BaseComboBox(this.getDatabaseConnection().getConnections().toArray());
        this.m_ComboBoxConnections.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MongoDbConnectionPanel.this.m_ComboBoxConnections.getSelectedIndex() == -1) {
                    return;
                }
                MongoDbConnectionPanel.this.displayParameters((MongoDbConnectionParameters)MongoDbConnectionPanel.this.m_ComboBoxConnections.getSelectedItem());
            }
        });
        this.m_PanelParameters.addParameter("_Connections", (Component)this.m_ComboBoxConnections);
        this.m_TextURL = new BaseTextField(20);
        this.m_PanelParameters.addParameter("_URL", (Component)this.m_TextURL);
        this.m_TextUser = new BaseTextField(20);
        this.m_PanelParameters.addParameter("U_ser", (Component)this.m_TextUser);
        this.m_TextPassword = new JPasswordField(20);
        this.m_TextPassword.setEchoChar('*');
        this.m_PanelParameters.addParameter("_Password", (Component)this.m_TextPassword);
        this.m_CheckBoxShowPassword = new BaseCheckBox();
        this.m_CheckBoxShowPassword.setSelected(false);
        this.m_CheckBoxShowPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MongoDbConnectionPanel.this.m_CheckBoxShowPassword.isSelected()) {
                    MongoDbConnectionPanel.this.m_TextPassword.setEchoChar('\u0000');
                } else {
                    MongoDbConnectionPanel.this.m_TextPassword.setEchoChar('*');
                }
            }
        });
        this.m_PanelParameters.addParameter("Sho_w password", (Component)this.m_CheckBoxShowPassword);
        this.m_TextAuthDB = new BaseTextField(20);
        this.m_PanelParameters.addParameter("Auth DB", (Component)this.m_TextAuthDB);
        this.m_ComboBoxLoggingLevel = new BaseComboBox((Object[])LoggingLevel.values());
        this.m_PanelParameters.addParameter("_Logging level", (Component)this.m_ComboBoxLoggingLevel);
        this.m_CheckBoxConnectOnStartUp = new BaseCheckBox();
        this.m_CheckBoxConnectOnStartUp.setSelected(false);
        this.m_PanelParameters.addParameter("Co_nnect on startup", (Component)this.m_CheckBoxConnectOnStartUp);
        JPanel panel2 = new JPanel(new BorderLayout());
        this.add(panel2, "South");
        this.m_LabelStatus = new JLabel();
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.m_LabelStatus);
        panel2.add((Component)panel, "West");
        panel = new JPanel(new FlowLayout(2));
        this.m_ButtonMakeDefault = new BaseButton("Make default");
        panel.add((Component)this.m_ButtonMakeDefault);
        this.m_ButtonMakeDefault.setMnemonic('m');
        this.m_ButtonMakeDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MongoDbConnectionPanel.this.m_ButtonMakeDefault.setEnabled(false);
                MongoDbConnectionPanel.this.makeDefault();
                MongoDbConnectionPanel.this.m_ButtonMakeDefault.setEnabled(true);
                MongoDbConnectionPanel.this.update();
            }
        });
        this.m_ButtonConnect = new BaseButton("Connect");
        panel.add((Component)this.m_ButtonConnect);
        this.m_ButtonConnect.setMnemonic('C');
        this.m_ButtonConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MongoDbConnectionPanel.this.doReconnect();
            }
        });
        panel2.add((Component)panel, "East");
    }

    protected void finishInit() {
        super.finishInit();
        this.update();
    }

    protected String getTitle() {
        return "MongoDB";
    }

    protected void displayParameters(MongoDbConnectionParameters conn) {
        this.m_TextURL.setText(conn.getURL());
        this.m_TextUser.setText(conn.getUser());
        this.m_TextPassword.setText(conn.getPassword().getValue());
        this.m_TextAuthDB.setText(conn.getAuthDB());
        this.m_ComboBoxLoggingLevel.setSelectedItem((Object)conn.getLoggingLevel());
        this.m_CheckBoxConnectOnStartUp.setSelected(conn.getConnectOnStartUp());
    }

    protected void displayParameters(MongoDbConnection conn) {
        this.displayParameters(conn.getCurrentConnection());
        boolean connected = conn.isConnected();
        List<MongoDbConnectionParameters> connections = conn.getConnections();
        MongoDbConnectionParameters current = conn.getCurrentConnection();
        int index = connections.indexOf(current);
        this.m_ComboBoxConnections.setModel(new DefaultComboBoxModel<Object>(connections.toArray()));
        this.m_ComboBoxConnections.setSelectedIndex(index);
        this.m_ComboBoxConnections.setEnabled(!connected);
        this.m_TextURL.setEditable(!connected);
        this.m_TextUser.setEditable(!connected);
        this.m_TextPassword.setEditable(!connected);
        this.m_CheckBoxShowPassword.setEnabled(!connected);
        this.m_TextAuthDB.setEditable(!connected);
        this.m_ComboBoxLoggingLevel.setEnabled(!connected);
        this.m_CheckBoxConnectOnStartUp.setEnabled(!connected);
        this.m_ButtonMakeDefault.setEnabled(!this.getCurrentParameters().equals(conn.getDefaultConnection()));
        if (connected) {
            this.m_ButtonConnect.setText("Disconnect");
        } else {
            this.m_ButtonConnect.setText("Connect");
        }
    }

    protected void doReconnect() {
        if (this.getDatabaseConnection().isConnected()) {
            this.getDatabaseConnection().disconnect();
        } else {
            try {
                MongoDbConnection conn = this.getCurrentParameters().toDatabaseConnection(MongoDbConnection.class);
                boolean result = conn.connect();
                if (!result) {
                    GUIHelper.showErrorMessage((Component)((Object)this), (String)"Failed to connect!");
                } else {
                    conn.addConnection(conn.getCurrentConnection());
                    if (conn.getOwner() != null) {
                        conn.getOwner().setDefault(conn);
                    }
                }
            }
            catch (Exception e) {
                GUIHelper.showErrorMessage((Component)((Object)this), (String)"Failed to connect!", (Throwable)e);
            }
        }
        this.notifyChangeListeners();
        this.showStatus("");
        this.update();
    }

    protected void makeDefault() {
        if (!this.getDatabaseConnection().makeDefaultConnection(this.getCurrentParameters())) {
            GUIHelper.showErrorMessage((Component)((Object)this.m_Self), (String)"Failed to make current connection the default one!");
        }
        this.notifyChangeListeners();
        this.showStatus("");
        this.update();
    }

    protected MongoDbConnectionParameters newConnectionParameters() {
        return new MongoDbConnectionParameters();
    }

    protected MongoDbConnectionParameters getCurrentParameters() {
        MongoDbConnectionParameters result = this.newConnectionParameters();
        result.setParameter("URL", this.m_TextURL.getText());
        result.setParameter("User", this.m_TextUser.getText());
        result.setParameter("Password", this.m_TextPassword.getText());
        result.setParameter("AuthDB", this.m_TextAuthDB.getText());
        result.setParameter("LoggingLevel", this.m_ComboBoxLoggingLevel.getSelectedItem().toString());
        result.setParameter("ConnectOnStartup", "" + this.m_CheckBoxConnectOnStartUp.isSelected());
        return result;
    }

    public MongoDbConnection getDatabaseConnection() {
        return MongoDbConnection.getSingleton();
    }

    public void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MongoDbConnectionPanel.this.displayParameters(MongoDbConnectionPanel.this.getDatabaseConnection());
            }
        });
    }

    protected void setEnabledState(boolean b) {
        this.m_ComboBoxConnections.setEnabled(b);
        this.m_TextURL.setEnabled(b);
        this.m_TextUser.setEnabled(b);
        this.m_TextPassword.setEnabled(b);
        this.m_CheckBoxShowPassword.setEnabled(b);
        this.m_TextAuthDB.setEnabled(b);
        this.m_ComboBoxLoggingLevel.setEnabled(b);
        this.m_CheckBoxConnectOnStartUp.setEnabled(b);
        this.m_ButtonMakeDefault.setEnabled(b);
        this.m_ButtonConnect.setEnabled(b);
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setEnabledState(b);
        this.update();
    }

    public void showStatus(final String msg) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                MongoDbConnectionPanel.this.m_LabelStatus.setText(msg);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public int compareTo(MongoDbConnectionPanel o) {
        return this.getTitle().compareTo(o.getTitle());
    }

    public boolean equals(Object o) {
        if (o instanceof MongoDbConnectionPanel) {
            return this.compareTo((MongoDbConnectionPanel)o) == 0;
        }
        return false;
    }

    public void addChangeListener(ChangeListener l) {
        this.m_ChangeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.m_ChangeListeners.remove(l);
    }

    protected void notifyChangeListeners() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : this.m_ChangeListeners) {
            l.stateChanged(event);
        }
    }

    public static String[] getPanels() {
        return ClassLister.getSingleton().getClassnames(MongoDbConnectionPanel.class);
    }
}

