/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.base.BasePassword;
import adams.db.MongoDbConnection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MongoDbManager
implements Serializable {
    private static final long serialVersionUID = -8832349882994980783L;
    protected String m_DatabaseName;
    protected HashMap<String, MongoDbConnection> m_Connections;
    protected MongoDbConnection m_DefaultDatabaseConnection;
    protected static HashMap<String, MongoDbConnection> m_AllConnections = new HashMap();

    public MongoDbManager(String dbName) {
        this.m_DatabaseName = dbName;
        this.m_Connections = new HashMap();
    }

    public String getDatabaseName() {
        return this.m_DatabaseName;
    }

    public String createURL(MongoDbConnection dbcon) {
        return this.createURL(dbcon.getURL(), dbcon.getUser(), dbcon.getPassword(), dbcon.getAuthDB());
    }

    public String createURL(String url, String user, BasePassword password, String authDB) {
        return user + ":" + password + "@" + url + "/" + authDB;
    }

    public boolean has(String url, String user, BasePassword password, String authDB) {
        if (url == null) {
            return false;
        }
        return this.m_Connections.containsKey(this.createURL(url, user, password, authDB));
    }

    public MongoDbConnection get(String url, String user, BasePassword password, String authDB) {
        if (url == null) {
            return null;
        }
        return this.m_Connections.get(this.createURL(url, user, password, authDB));
    }

    public MongoDbConnection add(MongoDbConnection dbcon) {
        if (dbcon == null) {
            return null;
        }
        dbcon.setOwner(this);
        String url = this.createURL(dbcon);
        m_AllConnections.put(url, dbcon);
        return this.m_Connections.put(url, dbcon);
    }

    public void setDefault(MongoDbConnection value) {
        this.m_DefaultDatabaseConnection = value;
        if (value != null) {
            this.m_DefaultDatabaseConnection.setOwner(this);
            this.add(value);
        }
    }

    public MongoDbConnection getDefault() {
        return this.m_DefaultDatabaseConnection;
    }

    public Iterator<MongoDbConnection> iterator() {
        return this.m_Connections.values().iterator();
    }

    public String toString() {
        return this.getDatabaseName() + ": " + this.m_Connections.keySet();
    }

    public static List<MongoDbConnection> getConnectionObjects() {
        return new ArrayList<MongoDbConnection>(m_AllConnections.values());
    }

    public static List<MongoDbConnection> getActiveConnectionObjects() {
        ArrayList<MongoDbConnection> result = new ArrayList<MongoDbConnection>();
        Collection<MongoDbConnection> conns = m_AllConnections.values();
        for (MongoDbConnection dbcon : conns) {
            if (!dbcon.isConnected()) continue;
            result.add(dbcon);
        }
        return result;
    }
}

