/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.base.AbstractBaseString;
import com.mongodb.MongoClientURI;

public class MongoDbUrl
extends AbstractBaseString {
    public static final String DEFAULT_URL = "mongodb://localhost:27017/somedatabase";
    private static final long serialVersionUID = 7278269302456796872L;

    public MongoDbUrl() {
        this(DEFAULT_URL);
    }

    public MongoDbUrl(String s) {
        super(s);
    }

    public boolean isValid(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        String[] parts = value.split(":");
        if (parts.length < 2) {
            return false;
        }
        return parts[0].equals("mongodb");
    }

    public String getTipText() {
        return "Format: 'mongodb:<server url>/database'";
    }

    public boolean hasFavoritesSupport() {
        return true;
    }

    public MongoClientURI uriValue() {
        return new MongoClientURI(this.getValue());
    }

    public String hostValue() {
        String result = this.getValue().replace("mongodb://", "");
        result = result.replaceAll("\\/.*", "");
        return result;
    }

    public int portValue() {
        int result = 27017;
        String portStr = this.getValue().replace("mongodb://", "");
        if (portStr.contains(":")) {
            portStr = portStr.replaceAll(".*\\:", "");
            portStr = portStr.replaceAll("([0-9]+).*", "$1");
            try {
                result = Integer.parseInt(portStr);
            }
            catch (Exception e) {
                System.err.println("Failed to parse: " + portStr);
                e.printStackTrace();
            }
        }
        return result;
    }
}

