/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.standalone.MongoDbConnection;
import java.util.logging.Level;

public class MongoDbActorUtils
extends ActorUtils {
    private static final Logger LOGGER = LoggingHelper.getConsoleLogger(ActorUtils.class);

    public static adams.db.MongoDbConnection getDatabaseConnection(Actor actor, Class cls, adams.db.MongoDbConnection defCon) {
        adams.db.MongoDbConnection result;
        Actor closest = ActorUtils.findClosestType((Actor)actor, (Class)cls, (boolean)true);
        if (closest != null) {
            if (closest instanceof MongoDbConnection) {
                result = ((MongoDbConnection)closest).getConnection();
                LOGGER.fine("Database connection found: " + result + "\n" + LoggingHelper.getStackTrace((int)20));
            } else if (closest instanceof MongoDbConnection) {
                result = ((MongoDbConnection)closest).getConnection();
                LOGGER.fine("Database connection found: " + result + "\n" + LoggingHelper.getStackTrace((int)20));
            } else {
                result = defCon;
                LOGGER.warning("Unhandled actor type '" + closest.getClass().getName() + "', using default connection: " + defCon + "\n" + LoggingHelper.getStackTrace((int)20));
            }
        } else {
            result = defCon;
            LOGGER.info("No database connection found, using default: " + defCon + "\n" + LoggingHelper.getStackTrace((int)20));
        }
        if (!result.isConnected() && result.getConnectOnStartUp()) {
            try {
                result.connect();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to enable database connection (" + cls.getName() + ") for actor " + actor.getFullName() + ":", (Throwable)e);
            }
        }
        return result;
    }
}

