/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.PasswordSupporter;
import adams.core.Placeholders;
import adams.core.QuickInfoHelper;
import adams.core.base.BasePassword;
import adams.core.io.ConsoleHelper;
import adams.core.option.OptionHandler;
import adams.db.MongoDbUrl;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.OptionalPasswordPrompt;
import adams.flow.core.StopHelper;
import adams.flow.core.StopMode;
import adams.flow.standalone.AbstractStandalone;
import adams.gui.dialog.PasswordDialog;
import java.awt.Dialog;
import java.awt.Window;

public class MongoDbConnection
extends AbstractStandalone
implements OptionalPasswordPrompt,
PasswordSupporter {
    private static final long serialVersionUID = -1726172998200420556L;
    protected MongoDbUrl m_URL;
    protected String m_User;
    protected BasePassword m_Password;
    protected BasePassword m_ActualPassword;
    protected boolean m_PromptForPassword;
    protected String m_AuthDB;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;
    protected StopMode m_StopMode;

    public String globalInfo() {
        return "Provides a MongoDB connection.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("url", "URL", (Object)new MongoDbUrl("mongodb://localhost:27017/somedatabase"), false);
        this.m_OptionManager.add("user", "user", (Object)"", false);
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(), false);
        this.m_OptionManager.add("prompt-for-password", "promptForPassword", (Object)false);
        this.m_OptionManager.add("auth-db", "authDB", (Object)"", false);
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", (Object)false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", (Object)"");
        this.m_OptionManager.add("stop-mode", "stopMode", (Object)StopMode.GLOBAL);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"URL", (Object)((Object)this.m_URL));
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"promptForPassword") || this.m_PromptForPassword) {
            result = result + ", prompt for password";
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"stopFlowIfCanceled", (boolean)this.m_StopFlowIfCanceled, (String)"stop flow", (String)", ");
        }
        return result;
    }

    public void setURL(MongoDbUrl value) {
        this.m_URL = value;
        this.reset();
    }

    public MongoDbUrl getURL() {
        return this.m_URL;
    }

    public String URLTipText() {
        return "The URL of the database to connect to, can contain variables or file placeholders.";
    }

    public String getResolvedURL() {
        String result = this.m_URL.getValue();
        result = this.getVariables().expand(result);
        result = Placeholders.expandStr((String)result);
        return result;
    }

    public void setUser(String value) {
        this.m_User = value;
        this.reset();
    }

    public String getUser() {
        return this.m_User;
    }

    public String userTipText() {
        return "The database user to connect with.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password of the database user.";
    }

    public void setPromptForPassword(boolean value) {
        this.m_PromptForPassword = value;
        this.reset();
    }

    public boolean getPromptForPassword() {
        return this.m_PromptForPassword;
    }

    public String promptForPasswordTipText() {
        return "If enabled and authentication is required, the user gets prompted for enter a password if none has been provided in the setup.";
    }

    public void setAuthDB(String value) {
        this.m_AuthDB = value;
        this.reset();
    }

    public String getAuthDB() {
        return this.m_AuthDB;
    }

    public String authDBTipText() {
        return "The name of the authentication database.";
    }

    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    public void setStopMode(StopMode value) {
        this.m_StopMode = value;
        this.reset();
    }

    public StopMode getStopMode() {
        return this.m_StopMode;
    }

    public String stopModeTipText() {
        return "The stop mode to use.";
    }

    public boolean doInteract() {
        boolean result;
        PasswordDialog dlg = new PasswordDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setLocationRelativeTo(this.getParentComponent());
        ((Flow)this.getRoot()).registerWindow((Window)dlg, dlg.getTitle());
        dlg.setVisible(true);
        ((Flow)this.getRoot()).deregisterWindow((Window)dlg);
        boolean bl = result = dlg.getOption() == 0;
        if (result) {
            this.m_ActualPassword = dlg.getPassword();
        }
        return result;
    }

    public boolean supportsHeadlessInteraction() {
        return true;
    }

    public boolean doInteractHeadless() {
        boolean result = false;
        BasePassword password = ConsoleHelper.enterPassword((String)("Please enter password (" + this.getName() + "):"));
        if (password != null) {
            result = true;
            this.m_ActualPassword = password;
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        this.m_ActualPassword = this.m_Password;
        adams.db.MongoDbConnection conn = null;
        if (this.m_PromptForPassword && this.m_Password.getValue().length() == 0) {
            if (!this.isHeadless()) {
                if (!this.doInteract() && this.m_StopFlowIfCanceled) {
                    if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                    } else {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                    }
                    result = this.getStopMessage();
                }
            } else if (this.supportsHeadlessInteraction() && !this.doInteractHeadless() && this.m_StopFlowIfCanceled) {
                if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                    StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                } else {
                    StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                }
                result = this.getStopMessage();
            }
        }
        if (result == null) {
            conn = this.getConnection();
            String msg = null;
            if (!conn.isConnected() && !conn.getConnectOnStartUp()) {
                try {
                    conn.connect();
                }
                catch (Exception e) {
                    msg = this.handleException("Failed to connect to database (" + (Object)((Object)this.getURL()) + "):", e);
                }
            }
            if (!conn.isConnected()) {
                result = "Failed to connect to database (" + (Object)((Object)this.getURL()) + ")";
                result = msg == null ? result + "!" : result + ": " + msg;
            }
        }
        return result;
    }

    public adams.db.MongoDbConnection getConnection() {
        return adams.db.MongoDbConnection.getSingleton(this.getResolvedURL(), this.getUser(), this.m_ActualPassword == null ? this.m_Password : this.m_ActualPassword, this.getAuthDB());
    }
}

