/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.MongoDbDocumentContainer;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.mongodbdocumentupdate.PassThrough;
import com.mongodb.client.MongoCollection;
import org.bson.Document;

public class MongoDbDocumentUpdate
extends AbstractTransformer {
    private static final long serialVersionUID = 296859358661875498L;
    protected adams.flow.transformer.mongodbdocumentupdate.MongoDbDocumentUpdate m_Operation;

    public String globalInfo() {
        return "Updates the documents passing through using the specified operation.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new PassThrough());
    }

    public void setOperation(adams.flow.transformer.mongodbdocumentupdate.MongoDbDocumentUpdate value) {
        this.m_Operation = value;
        this.reset();
    }

    public adams.flow.transformer.mongodbdocumentupdate.MongoDbDocumentUpdate getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The update operation.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)this.m_Operation, (String)"op: ");
    }

    public Class[] accepts() {
        return new Class[]{MongoDbDocumentContainer.class};
    }

    public Class[] generates() {
        return new Class[]{MongoDbDocumentContainer.class};
    }

    protected String doExecute() {
        String result;
        MongoDbDocumentContainer cont = (MongoDbDocumentContainer)((Object)this.m_InputToken.getPayload(MongoDbDocumentContainer.class));
        MongoCollection coll = (MongoCollection)cont.getValue("Collection", MongoCollection.class);
        Document doc = (Document)cont.getValue("Document", Document.class);
        try {
            this.m_Operation.setFlowContext((Actor)this);
            result = this.m_Operation.update(coll, doc);
            this.m_OutputToken = new Token((Object)new MongoDbDocumentContainer(coll, doc));
        }
        catch (Exception e) {
            result = this.handleException("Failed to update document, using: " + this.m_Operation, e);
        }
        return result;
    }
}

