/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.container.MongoDbDocumentContainer;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.ArrayList;
import java.util.Collections;
import org.bson.Document;

public class MongoDbGetDocumentKeys
extends AbstractArrayProvider {
    private static final long serialVersionUID = 597361990633872666L;

    public String globalInfo() {
        return "Forwards all the sorted (string) keys of the MongoDB document.";
    }

    public Class[] accepts() {
        return new Class[]{MongoDbDocumentContainer.class, Document.class};
    }

    protected Class getItemClass() {
        return String.class;
    }

    public String outputArrayTipText() {
        return "If enabled, the keys are output as an array rather than one-by-one";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (Object)(this.m_OutputArray ? "as array" : "one-by-one"));
    }

    protected String doExecute() {
        String result = null;
        Document doc = null;
        if (this.m_InputToken.hasPayload(MongoDbDocumentContainer.class)) {
            doc = (Document)((MongoDbDocumentContainer)((Object)this.m_InputToken.getPayload(MongoDbDocumentContainer.class))).getValue("Document");
        } else if (this.m_InputToken.hasPayload(Document.class)) {
            doc = (Document)this.m_InputToken.getPayload(Document.class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        this.m_Queue.clear();
        if (doc != null) {
            ArrayList items = new ArrayList(doc.keySet());
            Collections.sort(items);
            this.m_Queue.addAll(items);
        }
        return result;
    }
}

