/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.mongodbcollectionupdate;

import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.flow.transformer.mongodbcollectionupdate.AbstractMongoDbCollectionUpdate;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;

public class RemoveDocument
extends AbstractMongoDbCollectionUpdate {
    private static final long serialVersionUID = 3771202579365692102L;
    protected String m_ID;

    public String globalInfo() {
        return "Removes the document with the given ID.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("id", "ID", (Object)"");
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"ID", (Object)(this.m_ID.isEmpty() ? "-auto-" : this.m_ID), (String)"ID: ");
    }

    public void setID(String value) {
        this.m_ID = value;
        this.reset();
    }

    public String getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The ID of the document to remove.";
    }

    @Override
    protected String doUpdate(MongoCollection coll) {
        String result = null;
        if (this.m_ID.isEmpty()) {
            result = "No ID supplied!";
        }
        if (result == null) {
            try {
                coll.deleteOne(Filters.eq((String)"_id", (Object)this.m_ID));
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to add document!", (Throwable)e);
            }
        }
        return result;
    }
}

