/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.mongodbdocumentupdate;

import adams.core.MessageCollection;
import adams.core.base.BaseKeyValuePair;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.data.conversion.ConversionFromString;
import adams.flow.transformer.mongodbdocumentupdate.AbstractMongoDbDocumentUpdate;
import adams.flow.transformer.mongodbdocumentupdate.MongoDbDocumentAppend;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import org.bson.Document;

public abstract class AbstractAppend
extends AbstractMongoDbDocumentUpdate
implements MongoDbDocumentAppend {
    private static final long serialVersionUID = 3771202579365692102L;
    protected BaseKeyValuePair[] m_KeyValuePairs;
    protected ConversionFromString m_ValueConversion;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key-value", "keyValuePairs", (Object)new BaseKeyValuePair[0]);
        this.m_OptionManager.add("value-conversion", "valueConversion", (Object)this.getDefaultValueConversion());
    }

    public void setKeyValuePairs(BaseKeyValuePair[] value) {
        this.m_KeyValuePairs = value;
        this.reset();
    }

    public BaseKeyValuePair[] getKeyValuePairs() {
        return this.m_KeyValuePairs;
    }

    public abstract String keyValuePairsTipText();

    protected abstract ConversionFromString getDefaultValueConversion();

    public void setValueConversion(ConversionFromString value) {
        this.m_ValueConversion = value;
        this.reset();
    }

    public ConversionFromString getValueConversion() {
        return this.m_ValueConversion;
    }

    public abstract String valueConversionTipText();

    protected abstract Object getActualValue(String var1);

    @Override
    protected String doUpdate(MongoCollection coll, Document doc) {
        String result = null;
        MessageCollection errors = new MessageCollection();
        try {
            for (BaseKeyValuePair pair : this.m_KeyValuePairs) {
                Object val = this.getActualValue(pair.getPairValue());
                this.m_ValueConversion.setInput(val);
                String msg = this.m_ValueConversion.convert();
                if (msg != null) {
                    errors.add("Failed to convert " + pair + " using " + this.m_ValueConversion + "\n" + msg);
                    continue;
                }
                val = this.m_ValueConversion.getOutput();
                doc.append(pair.getPairKey(), val);
            }
            if (errors.isEmpty()) {
                coll.deleteOne(Filters.eq((String)"_id", (Object)doc.get((Object)"_id")));
                coll.insertOne((Object)doc);
            }
        }
        catch (Exception e) {
            errors.add(LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to update document!", (Throwable)e));
        }
        if (!errors.isEmpty()) {
            result = errors.toString();
        }
        return result;
    }
}

