/*
 * Decompiled with CFR 0.152.
 */
package adams.opt.genetic.setupupload;

import adams.core.Shortening;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.db.MongoDbConnection;
import adams.db.MongoDbUrl;
import adams.flow.core.MongoDbActorUtils;
import adams.flow.standalone.DatabaseConnectionProvider;
import adams.opt.genetic.AbstractGeneticAlgorithm;
import adams.opt.genetic.setupupload.AbstractSetupUpload;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.util.Map;
import org.bson.Document;

public class MongoDB
extends AbstractSetupUpload {
    private static final long serialVersionUID = 1825847990988418348L;
    public static final String KEY_SUCCESSFUL = "successful";
    protected MongoDbConnection m_DatabaseConnection;
    protected MongoDatabase m_Database;

    public String globalInfo() {
        return "Stores the setup information in the MongoDB collection (aka experiment).\nUses the database available through the current flow context.\nIf the collection is not present, it gets automatically created.\nOn completion of the algorithm run, a document with the key 'successful' gets inserted with an associated value of 'true' or 'false' depending on whether the algorithm run was successful. The fitness value is not present in this case.";
    }

    protected void reset() {
        super.reset();
        this.m_DatabaseConnection = null;
        this.m_Database = null;
    }

    public boolean requiresFlowContext() {
        return true;
    }

    protected String initDatabase() {
        if (this.m_DatabaseConnection != null) {
            return null;
        }
        this.m_DatabaseConnection = MongoDbActorUtils.getDatabaseConnection(this.getFlowContext(), DatabaseConnectionProvider.class, new MongoDbConnection());
        if (this.m_DatabaseConnection == null) {
            return "Failed to initialize database connection!";
        }
        return null;
    }

    protected String initCollection() {
        String result = null;
        try {
            MongoDbUrl url = new MongoDbUrl(this.m_DatabaseConnection.getURL());
            String database = url.uriValue().getDatabase();
            MongoClient mongoclient = this.m_DatabaseConnection.getConnection(true);
            if (mongoclient == null) {
                result = "Failed to obtain connection: " + this.m_DatabaseConnection.getURL();
            } else {
                this.m_Database = mongoclient.getDatabase(database);
                try {
                    this.m_Database.getCollection(this.m_Experiment);
                }
                catch (IllegalArgumentException e) {
                    this.m_Database.createCollection(this.m_Experiment);
                }
            }
        }
        catch (Exception e) {
            result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to load collection: " + this.m_Experiment), (Throwable)e);
        }
        return result;
    }

    protected void doStart(AbstractGeneticAlgorithm algorithm) {
    }

    protected String doUpload(Map<String, Object> setup) {
        String result = this.initDatabase();
        if (result == null) {
            result = this.initCollection();
        }
        MongoCollection coll = null;
        if (result == null) {
            try {
                coll = this.m_Database.getCollection(this.m_Experiment);
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)("Failed to get collection: " + this.m_Experiment), (Throwable)e);
            }
        }
        if (coll != null) {
            Document doc = new Document("_id", (Object)(setup.get("Measure") + "|" + setup.get("Fitness")));
            for (String key : setup.keySet()) {
                String bsonKey = key.replace(".", "_");
                doc.put(bsonKey, setup.get(key));
                if (!this.isLoggingEnabled()) continue;
                this.getLogger().info("Inserting name=" + key + ", value=" + Shortening.shortenEnd((String)("" + setup.get(key)), (int)30));
            }
            try {
                coll.insertOne((Object)doc);
            }
            catch (Exception e) {
                result = LoggingHelper.handleException((LoggingSupporter)this, (String)"Failed to insert setup document!", (Throwable)e);
            }
        }
        return result;
    }

    protected void doFinish(AbstractGeneticAlgorithm algorithm, String error, Map<String, Object> params) {
        params.put(KEY_SUCCESSFUL, error);
        this.upload(params);
    }
}

