/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.base.BaseURL;
import adams.core.io.PlaceholderFile;
import adams.core.net.InetUtils;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractOnlineFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DownloadFile;
import adams.flow.source.SingleURLSupplier;
import junit.framework.Test;
import junit.framework.TestSuite;

public class DownloadFileTest
extends AbstractOnlineFlowTest {
    public DownloadFileTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.deleteFileFromTmp("out.html");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("out.html");
        super.tearDown();
    }

    public static Test suite() {
        return new TestSuite(DownloadFileTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        String host = "www.cms.waikato.ac.nz";
        if (!InetUtils.hasConnection((String)host, (int)3000)) {
            System.err.println("No connection to host '" + host + "'? Trying anyway...");
        }
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp1 = new AbstractActor[2];
            SingleURLSupplier tmp2 = new SingleURLSupplier();
            argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("URL");
            tmp2.setURL((BaseURL)argOption.valueOf("http://" + host + "/~ml/index.html"));
            tmp1[0] = tmp2;
            DownloadFile tmp4 = new DownloadFile();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("outputFile");
            tmp4.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/out.html"));
            tmp1[1] = tmp4;
            flow.setActors(tmp1);
        }
        catch (Exception e) {
            DownloadFileTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        DownloadFileTest.runTest((Test)DownloadFileTest.suite());
    }
}

