/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.MutableActorHandler;
import adams.flow.processor.AbstractModifyingProcessor;
import adams.flow.processor.CleanUpProcessor;
import adams.flow.sink.Email;
import adams.flow.sink.SendEmail;
import adams.flow.transformer.CreateEmail;
import java.util.List;

public class FixDeprecatedEmail
extends AbstractModifyingProcessor
implements CleanUpProcessor {
    private static final long serialVersionUID = -4170658262349662939L;

    public String globalInfo() {
        return "Replaces the Email sink with CreateEmail and SendEmail instances.";
    }

    protected CreateEmail toCreateEmail(Email email) {
        CreateEmail result = new CreateEmail();
        result.setName(email.getName());
        String var = email.getOptionManager().getVariableForProperty("sender");
        if (var != null) {
            result.getOptionManager().setVariableForProperty("sender", var);
        } else {
            result.setSender(email.getSender());
        }
        var = email.getOptionManager().getVariableForProperty("recipients");
        if (var != null) {
            result.getOptionManager().setVariableForProperty("recipients", var);
        } else {
            result.setRecipients(email.getRecipients());
        }
        var = email.getOptionManager().getVariableForProperty("CC");
        if (var != null) {
            result.getOptionManager().setVariableForProperty("CC", var);
        } else {
            result.setCC(email.getCC());
        }
        var = email.getOptionManager().getVariableForProperty("BCC");
        if (var != null) {
            result.getOptionManager().setVariableForProperty("BCC", var);
        } else {
            result.setBCC(email.getBCC());
        }
        var = email.getOptionManager().getVariableForProperty("subject");
        if (var != null) {
            result.getOptionManager().setVariableForProperty("subject", var);
        } else {
            result.setSubject(email.getSubject());
        }
        var = email.getOptionManager().getVariableForProperty("body");
        if (var != null) {
            result.getOptionManager().setVariableForProperty("body", var);
        } else {
            result.setBody(email.getBody());
        }
        var = email.getOptionManager().getVariableForProperty("signature");
        if (var != null) {
            result.getOptionManager().setVariableForProperty("signature", var);
        } else {
            result.setSignature(email.getSignature());
        }
        return result;
    }

    protected SendEmail toSendEmail(Email email) {
        SendEmail result = new SendEmail();
        result.setName(email.getName());
        String var = email.getOptionManager().getVariableForProperty("sendEmail");
        if (var != null) {
            result.getOptionManager().setVariableForProperty("sendEmail", var);
        } else {
            result.setSendEmail(email.getSendEmail());
        }
        return result;
    }

    protected void processActor(AbstractActor actor) {
        List emails = ActorUtils.enumerate((AbstractActor)actor, (Class[])new Class[]{Email.class});
        for (AbstractActor email : emails) {
            Email eactor = (Email)email;
            CreateEmail cemail = this.toCreateEmail(eactor);
            SendEmail semail = this.toSendEmail(eactor);
            int index = eactor.index();
            ((MutableActorHandler)eactor.getParent()).add(index, (AbstractActor)cemail);
            ((MutableActorHandler)eactor.getParent()).set(index + 1, (AbstractActor)semail);
            this.m_Modified = true;
        }
    }
}

