/*
 * Decompiled with CFR 0.152.
 */
package adams.core.base;

import adams.core.base.AbstractBaseString;

public class BaseHostname
extends AbstractBaseString {
    private static final long serialVersionUID = -1171165120084607705L;
    public static final String VALID_CHARS = "abcdefghijklmnopqrstuvwxyz0123456789-.:";

    public BaseHostname() {
        super("");
    }

    public BaseHostname(String s) {
        super(s);
    }

    public boolean isValid(String value) {
        boolean result = true;
        value = value.toLowerCase();
        for (int i = 0; i < value.length(); ++i) {
            if (VALID_CHARS.indexOf(value.charAt(i)) != -1) continue;
            result = false;
            break;
        }
        if (result && value.indexOf(58) > -1) {
            String[] parts = value.split(":");
            boolean bl = result = parts.length == 2;
            if (result) {
                try {
                    int port = Integer.parseInt(parts[1]);
                    result = port >= 0 && port <= 65535;
                }
                catch (Exception e) {
                    result = false;
                }
            }
        }
        return result;
    }

    public String hostnameValue() {
        if (!this.getValue().contains(":")) {
            return this.getValue();
        }
        return this.getValue().split(":")[0];
    }

    public int portValue() {
        return this.portValue(-1);
    }

    public int portValue(int defPort) {
        if (!this.getValue().contains(":")) {
            return defPort;
        }
        return Integer.parseInt(this.getValue().split(":")[1]);
    }

    public String getTipText() {
        return "Hostname with optional port number (format: 'host:port')";
    }
}

