/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractEmailReader;
import adams.data.io.input.EmailFileReader;

public abstract class AbstractEmailFileReader
extends AbstractEmailReader
implements EmailFileReader {
    private static final long serialVersionUID = -815445698354646307L;
    protected PlaceholderFile m_Input;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("input", "input", (Object)new PlaceholderFile("."));
    }

    public String getDefaultFormatExtension() {
        return this.getFormatExtensions()[0];
    }

    @Override
    public void setInput(PlaceholderFile value) {
        this.m_Input = value;
        this.reset();
    }

    @Override
    public PlaceholderFile getInput() {
        return this.m_Input;
    }

    @Override
    public String inputTipText() {
        return "The file to read the email from.";
    }

    @Override
    protected void check() {
        super.check();
        if (!this.m_Input.exists()) {
            throw new IllegalStateException("Input file does not exist: " + this.m_Input);
        }
        if (!this.m_Input.isFile()) {
            throw new IllegalStateException("Input is not a file: " + this.m_Input);
        }
    }
}

