/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.source.AbstractArrayProvider;
import adams.flow.standalone.FTPConnection;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;

public class FTPLister
extends AbstractArrayProvider {
    private static final long serialVersionUID = -5015637337437403790L;
    protected String m_RemoteDir;
    protected BaseRegExp m_RegExp;
    protected boolean m_ListDirs;
    protected boolean m_ListFiles;
    protected Sorting m_Sorting;
    protected boolean m_SortDescending;
    protected FTPConnection m_Connection;

    public String globalInfo() {
        return "Returns the contents of a FTP directory (files/dirs).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("remote-dir", "remoteDir", (Object)"/pub");
        this.m_OptionManager.add("list-dirs", "listDirs", (Object)false);
        this.m_OptionManager.add("list-files", "listFiles", (Object)false);
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(""));
        this.m_OptionManager.add("sorting", "sorting", (Object)Sorting.NO_SORTING);
        this.m_OptionManager.add("descending", "sortDescending", (Object)false);
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"remoteDir", (Object)this.m_RemoteDir);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (Object)(this.m_OutputArray ? "as array" : "one by one"), (String)", ");
        return result;
    }

    public void setRemoteDir(String value) {
        this.m_RemoteDir = value;
        this.reset();
    }

    public String getRemoteDir() {
        return this.m_RemoteDir;
    }

    public String remoteDirTipText() {
        return "The FTP directory to list the files for.";
    }

    public String outputArrayTipText() {
        return "Whether to output the files as array or as single strings.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression that the files/dirs must match (empty string matches all).";
    }

    public void setListDirs(boolean value) {
        this.m_ListDirs = value;
        this.reset();
    }

    public boolean getListDirs() {
        return this.m_ListDirs;
    }

    public String listDirsTipText() {
        return "Whether to include directories in the output.";
    }

    public void setListFiles(boolean value) {
        this.m_ListFiles = value;
        this.reset();
    }

    public boolean getListFiles() {
        return this.m_ListFiles;
    }

    public String listFilesTipText() {
        return "Whether to include files in the output.";
    }

    public void setSorting(Sorting value) {
        this.m_Sorting = value;
        this.reset();
    }

    public Sorting getSorting() {
        return this.m_Sorting;
    }

    public String sortingTipText() {
        return "The type of sorting to perform.";
    }

    public void setSortDescending(boolean value) {
        this.m_SortDescending = value;
        this.reset();
    }

    public boolean getSortDescending() {
        return this.m_SortDescending;
    }

    public String sortDescendingTipText() {
        return "If set to true, the files are sorted in descending manner.";
    }

    protected Class getItemClass() {
        return String.class;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_Connection = (FTPConnection)ActorUtils.findClosestType((AbstractActor)this, FTPConnection.class);
            if (this.m_Connection == null) {
                result = "No " + FTPConnection.class.getName() + " actor found!";
            }
        }
        return result;
    }

    protected String doExecute() {
        FTPFile[] files;
        String result = null;
        this.m_Queue.clear();
        FTPClient client = this.m_Connection.getFTPClient();
        if (this.m_ListDirs) {
            try {
                if (this.m_RemoteDir.length() > 0) {
                    client.changeWorkingDirectory(this.m_RemoteDir);
                }
                for (FTPFile file : files = client.listDirectories()) {
                    if (!this.isStopped()) {
                        if (file == null || !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatchAll() && !this.m_RegExp.isMatch(file.getName())) continue;
                        this.m_Queue.add(file.getName());
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to list directories in '" + this.m_RemoteDir + "': ", e);
            }
        }
        if (result == null && this.m_ListFiles) {
            try {
                if (this.m_RemoteDir.length() > 0) {
                    client.changeWorkingDirectory(this.m_RemoteDir);
                }
                for (FTPFile file : files = client.listFiles()) {
                    if (!this.isStopped()) {
                        if (file == null || file.isDirectory() || !this.m_RegExp.isEmpty() && !this.m_RegExp.isMatchAll() && !this.m_RegExp.isMatch(file.getName())) continue;
                        this.m_Queue.add(file.getName());
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to list files in '" + this.m_RemoteDir + "': ", e);
            }
        }
        if (this.isStopped()) {
            this.m_Queue.clear();
        }
        return result;
    }

    public static enum Sorting {
        NO_SORTING,
        SORT_BY_NAME,
        SORT_BY_LAST_MODIFIED;

    }
}

